/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.nettyutil.handler;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.MessageToByteEncoder;
import org.opendaylight.controller.netconf.nettyutil.handler.ChunkedFramingMechanismEncoder;
import org.opendaylight.controller.netconf.nettyutil.handler.EOMFramingMechanismEncoder;
import org.opendaylight.controller.netconf.util.messages.FramingMechanism;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FramingMechanismHandlerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FramingMechanismHandlerFactory.class);

    private FramingMechanismHandlerFactory() {
    }

    public static MessageToByteEncoder<ByteBuf> createHandler(FramingMechanism framingMechanism) {
        LOG.debug("{} framing mechanism was selected.", (Object)framingMechanism);
        if (framingMechanism == FramingMechanism.EOM) {
            return new EOMFramingMechanismEncoder();
        }
        return new ChunkedFramingMechanismEncoder();
    }
}

