/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.nettyutil.handler;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.openexi.proc.HeaderOptionsOutputType;
import org.openexi.proc.common.EXIOptions;
import org.openexi.proc.common.EXIOptionsException;
import org.openexi.proc.common.GrammarOptions;
import org.openexi.proc.grammars.GrammarCache;
import org.openexi.sax.EXIReader;
import org.openexi.sax.Transmogrifier;
import org.openexi.sax.TransmogrifierException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class NetconfEXICodec {
    private static final boolean OUTPUT_EXI_COOKIE = true;
    private static final EntityResolver ENTITY_RESOLVER = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource();
        }
    };
    private static final LoadingCache<Short, GrammarCache> GRAMMAR_CACHES = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<Short, GrammarCache>(){

        public GrammarCache load(Short key) {
            return new GrammarCache(key.shortValue());
        }
    });
    private final GrammarCache exiGrammarCache;
    private final EXIOptions exiOptions;

    public NetconfEXICodec(EXIOptions exiOptions) {
        this.exiOptions = (EXIOptions)Preconditions.checkNotNull((Object)exiOptions);
        this.exiGrammarCache = NetconfEXICodec.createGrammarCache(exiOptions);
    }

    private static GrammarCache createGrammarCache(EXIOptions exiOptions) {
        short go = 2;
        if (exiOptions.getPreserveComments()) {
            go = GrammarOptions.addCM((short)go);
        }
        if (exiOptions.getPreserveDTD()) {
            go = GrammarOptions.addDTD((short)go);
        }
        if (exiOptions.getPreserveNS()) {
            go = GrammarOptions.addNS((short)go);
        }
        if (exiOptions.getPreservePIs()) {
            go = GrammarOptions.addPI((short)go);
        }
        return (GrammarCache)GRAMMAR_CACHES.getUnchecked((Object)go);
    }

    EXIReader getReader() throws EXIOptionsException {
        EXIReader r = new EXIReader();
        r.setPreserveLexicalValues(this.exiOptions.getPreserveLexicalValues());
        r.setGrammarCache(this.exiGrammarCache);
        r.setEntityResolver(ENTITY_RESOLVER);
        return r;
    }

    Transmogrifier getTransmogrifier() throws EXIOptionsException, TransmogrifierException {
        Transmogrifier transmogrifier = new Transmogrifier();
        transmogrifier.setAlignmentType(this.exiOptions.getAlignmentType());
        transmogrifier.setBlockSize(this.exiOptions.getBlockSize());
        transmogrifier.setGrammarCache(this.exiGrammarCache);
        transmogrifier.setOutputCookie(true);
        transmogrifier.setOutputOptions(HeaderOptionsOutputType.all);
        transmogrifier.setResolveExternalGeneralEntities(false);
        return transmogrifier;
    }
}

