/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.nettyutil.handler;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.nettyutil.handler.NetconfEXICodec;
import org.openexi.proc.common.EXIOptionsException;
import org.openexi.sax.EXIReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class NetconfEXIToMessageDecoder
extends ByteToMessageDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfEXIToMessageDecoder.class);
    private static final SAXTransformerFactory FACTORY = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    private final EXIReader reader;

    private NetconfEXIToMessageDecoder(EXIReader reader) {
        this.reader = (EXIReader)Preconditions.checkNotNull((Object)reader);
    }

    public static NetconfEXIToMessageDecoder create(NetconfEXICodec codec) throws EXIOptionsException {
        return new NetconfEXIToMessageDecoder(codec.getReader());
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws EXIOptionsException, IOException, SAXException, TransformerConfigurationException {
        if (!in.isReadable()) {
            LOG.debug("No more content in incoming buffer.");
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Received to decode: {}", (Object)ByteBufUtil.hexDump((ByteBuf)in));
        }
        TransformerHandler handler = FACTORY.newTransformerHandler();
        this.reader.setContentHandler((ContentHandler)handler);
        DOMResult domResult = new DOMResult();
        handler.setResult(domResult);
        try (ByteBufInputStream is = new ByteBufInputStream(in);){
            this.reader.parse(new InputSource((InputStream)is));
        }
        out.add(new NetconfMessage((Document)domResult.getNode()));
    }
}

