/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.nettyutil.handler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.nettyutil.handler.NetconfMessageToXMLEncoder;
import org.opendaylight.controller.netconf.util.messages.NetconfHelloMessage;
import org.opendaylight.controller.netconf.util.messages.NetconfHelloMessageAdditionalHeader;

public final class NetconfHelloMessageToXMLEncoder
extends NetconfMessageToXMLEncoder {
    @Override
    @VisibleForTesting
    public void encode(ChannelHandlerContext ctx, NetconfMessage msg, ByteBuf out) throws IOException, TransformerException {
        Preconditions.checkState((boolean)(msg instanceof NetconfHelloMessage), (String)"Netconf message of type %s expected, was %s", (Object[])new Object[]{NetconfHelloMessage.class, msg.getClass()});
        Optional headerOptional = ((NetconfHelloMessage)msg).getAdditionalHeader();
        if (headerOptional.isPresent()) {
            out.writeBytes(((NetconfHelloMessageAdditionalHeader)headerOptional.get()).toFormattedString().getBytes(Charsets.UTF_8));
        }
        super.encode(ctx, msg, out);
    }
}

