/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.nettyutil.handler;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.nettyutil.handler.NetconfEXICodec;
import org.opendaylight.controller.netconf.nettyutil.handler.ThreadLocalTransformers;
import org.openexi.proc.common.EXIOptionsException;
import org.openexi.sax.SAXTransmogrifier;
import org.openexi.sax.Transmogrifier;
import org.openexi.sax.TransmogrifierException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public final class NetconfMessageToEXIEncoder
extends MessageToByteEncoder<NetconfMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfMessageToEXIEncoder.class);
    private final Transmogrifier transmogrifier;

    private NetconfMessageToEXIEncoder(Transmogrifier transmogrifier) {
        this.transmogrifier = (Transmogrifier)Preconditions.checkNotNull((Object)transmogrifier);
    }

    public static NetconfMessageToEXIEncoder create(NetconfEXICodec codec) throws EXIOptionsException, TransmogrifierException {
        return new NetconfMessageToEXIEncoder(codec.getTransmogrifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, NetconfMessage msg, ByteBuf out) throws EXIOptionsException, IOException, TransformerException, TransmogrifierException {
        LOG.trace("Sent to encode : {}", (Object)msg);
        try (ByteBufOutputStream os = new ByteBufOutputStream(out);){
            this.transmogrifier.setOutputStream((OutputStream)os);
            SAXTransmogrifier handler = this.transmogrifier.getSAXTransmogrifier();
            Transformer transformer = ThreadLocalTransformers.getDefaultTransformer();
            transformer.transform(new DOMSource(msg.getDocument()), new SAXResult((ContentHandler)handler));
        }
        finally {
            this.transmogrifier.setOutputStream(null);
            this.transmogrifier.getSAXTransmogrifier();
        }
    }
}

