/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.nettyutil.handler.exi;

import com.google.common.base.Preconditions;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.openexi.proc.common.AlignmentType;
import org.openexi.proc.common.EXIOptions;
import org.openexi.proc.common.EXIOptionsException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class EXIParameters {
    private static final String EXI_PARAMETER_ALIGNMENT = "alignment";
    static final String EXI_PARAMETER_BYTE_ALIGNED = "byte-aligned";
    static final String EXI_PARAMETER_BIT_PACKED = "bit-packed";
    static final String EXI_PARAMETER_COMPRESSED = "compressed";
    static final String EXI_PARAMETER_PRE_COMPRESSION = "pre-compression";
    private static final String EXI_PARAMETER_FIDELITY = "fidelity";
    private static final String EXI_FIDELITY_DTD = "dtd";
    private static final String EXI_FIDELITY_LEXICAL_VALUES = "lexical-values";
    private static final String EXI_FIDELITY_COMMENTS = "comments";
    private static final String EXI_FIDELITY_PIS = "pis";
    private static final String EXI_FIDELITY_PREFIXES = "prefixes";
    private final EXIOptions options;

    private EXIParameters(EXIOptions options) {
        this.options = (EXIOptions)Preconditions.checkNotNull((Object)options);
    }

    public static EXIParameters fromXmlElement(XmlElement root) throws EXIOptionsException {
        EXIOptions options = new EXIOptions();
        options.setAlignmentType(AlignmentType.bitPacked);
        NodeList alignmentElements = root.getElementsByTagName(EXI_PARAMETER_ALIGNMENT);
        if (alignmentElements.getLength() > 0) {
            String alignmentTextContent;
            Element alignmentElement = (Element)alignmentElements.item(0);
            switch (alignmentTextContent = alignmentElement.getTextContent().trim()) {
                case "bit-packed": {
                    options.setAlignmentType(AlignmentType.bitPacked);
                    break;
                }
                case "byte-aligned": {
                    options.setAlignmentType(AlignmentType.byteAligned);
                    break;
                }
                case "compressed": {
                    options.setAlignmentType(AlignmentType.compress);
                    break;
                }
                case "pre-compression": {
                    options.setAlignmentType(AlignmentType.preCompress);
                }
            }
        }
        if (root.getElementsByTagName(EXI_PARAMETER_FIDELITY).getLength() > 0) {
            if (root.getElementsByTagName(EXI_FIDELITY_DTD).getLength() > 0) {
                options.setPreserveDTD(true);
            }
            if (root.getElementsByTagName(EXI_FIDELITY_LEXICAL_VALUES).getLength() > 0) {
                options.setPreserveLexicalValues(true);
            }
            if (root.getElementsByTagName(EXI_FIDELITY_COMMENTS).getLength() > 0) {
                options.setPreserveComments(true);
            }
            if (root.getElementsByTagName(EXI_FIDELITY_PIS).getLength() > 0) {
                options.setPreservePIs(true);
            }
            if (root.getElementsByTagName(EXI_FIDELITY_PREFIXES).getLength() > 0) {
                options.setPreserveNS(true);
            }
        }
        return new EXIParameters(options);
    }

    public final EXIOptions getOptions() {
        return this.options;
    }
}

