/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.nettyutil.handler.exi;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.openexi.proc.common.EXIOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class NetconfStartExiMessage
extends NetconfMessage {
    public static final String START_EXI = "start-exi";
    public static final String ALIGNMENT_KEY = "alignment";
    public static final String FIDELITY_KEY = "fidelity";
    public static final String COMMENTS_KEY = "comments";
    public static final String DTD_KEY = "dtd";
    public static final String LEXICAL_VALUES_KEY = "lexical-values";
    public static final String PIS_KEY = "pis";
    public static final String PREFIXES_KEY = "prefixes";

    private NetconfStartExiMessage(Document doc) {
        super(doc);
    }

    public static NetconfStartExiMessage create(EXIOptions exiOptions, String messageId) {
        Document doc = XmlUtil.newDocument();
        Element rpcElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "rpc");
        rpcElement.setAttributeNS("urn:ietf:params:xml:ns:netconf:base:1.0", "message-id", messageId);
        Element startExiElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:exi:1.0", START_EXI);
        NetconfStartExiMessage.addAlignment(exiOptions, doc, startExiElement);
        NetconfStartExiMessage.addFidelity(exiOptions, doc, startExiElement);
        rpcElement.appendChild(startExiElement);
        doc.appendChild(rpcElement);
        return new NetconfStartExiMessage(doc);
    }

    private static void addFidelity(EXIOptions exiOptions, Document doc, Element startExiElement) {
        ArrayList fidelityElements = Lists.newArrayList();
        NetconfStartExiMessage.createFidelityElement(doc, fidelityElements, exiOptions.getPreserveComments(), COMMENTS_KEY);
        NetconfStartExiMessage.createFidelityElement(doc, fidelityElements, exiOptions.getPreserveDTD(), DTD_KEY);
        NetconfStartExiMessage.createFidelityElement(doc, fidelityElements, exiOptions.getPreserveLexicalValues(), LEXICAL_VALUES_KEY);
        NetconfStartExiMessage.createFidelityElement(doc, fidelityElements, exiOptions.getPreservePIs(), PIS_KEY);
        NetconfStartExiMessage.createFidelityElement(doc, fidelityElements, exiOptions.getPreserveNS(), PREFIXES_KEY);
        if (!fidelityElements.isEmpty()) {
            Element fidelityElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:exi:1.0", FIDELITY_KEY);
            for (Element element : fidelityElements) {
                fidelityElement.appendChild(element);
            }
            startExiElement.appendChild(fidelityElement);
        }
    }

    private static void addAlignment(EXIOptions exiOptions, Document doc, Element startExiElement) {
        Element alignmentElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:exi:1.0", ALIGNMENT_KEY);
        String alignmentString = "bit-packed";
        switch (exiOptions.getAlignmentType()) {
            case byteAligned: {
                alignmentString = "byte-aligned";
                break;
            }
            case bitPacked: {
                alignmentString = "bit-packed";
                break;
            }
            case compress: {
                alignmentString = "compressed";
                break;
            }
            case preCompress: {
                alignmentString = "pre-compression";
            }
        }
        alignmentElement.setTextContent(alignmentString);
        startExiElement.appendChild(alignmentElement);
    }

    private static void createFidelityElement(Document doc, List<Element> fidelityElements, boolean fidelity, String fidelityName) {
        if (fidelity) {
            fidelityElements.add(doc.createElementNS("urn:ietf:params:xml:ns:netconf:exi:1.0", fidelityName));
        }
    }
}

