/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.auth.usermanager;

import com.google.common.annotations.VisibleForTesting;
import org.opendaylight.controller.netconf.auth.AuthProvider;
import org.opendaylight.controller.sal.authorization.AuthResultEnum;
import org.opendaylight.controller.usermanager.IUserManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthProviderImpl
implements AuthProvider {
    private static final Logger logger = LoggerFactory.getLogger(AuthProviderImpl.class);
    private IUserManager nullableUserManager;

    public AuthProviderImpl(final BundleContext bundleContext) {
        ServiceTrackerCustomizer<IUserManager, IUserManager> customizer = new ServiceTrackerCustomizer<IUserManager, IUserManager>(){

            public IUserManager addingService(ServiceReference<IUserManager> reference) {
                logger.trace("UerManager {} added", reference);
                AuthProviderImpl.this.nullableUserManager = (IUserManager)bundleContext.getService(reference);
                return AuthProviderImpl.this.nullableUserManager;
            }

            public void modifiedService(ServiceReference<IUserManager> reference, IUserManager service) {
                logger.trace("Replacing modified UerManager {}", reference);
                AuthProviderImpl.this.nullableUserManager = service;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(ServiceReference<IUserManager> reference, IUserManager service) {
                logger.trace("Removing UerManager {}. This AuthProvider will fail to authenticate every time", reference);
                AuthProviderImpl authProviderImpl = AuthProviderImpl.this;
                synchronized (authProviderImpl) {
                    AuthProviderImpl.this.nullableUserManager = null;
                }
            }
        };
        ServiceTracker listenerTracker = new ServiceTracker(bundleContext, IUserManager.class, (ServiceTrackerCustomizer)customizer);
        listenerTracker.open();
    }

    public synchronized boolean authenticated(String username, String password) {
        if (this.nullableUserManager == null) {
            logger.warn("Cannot authenticate user '{}', user manager service is missing", (Object)username);
            throw new IllegalStateException("User manager service is not available");
        }
        AuthResultEnum authResult = this.nullableUserManager.authenticate(username, password);
        logger.debug("Authentication result for user '{}' : {}", (Object)username, (Object)authResult);
        return authResult.equals((Object)AuthResultEnum.AUTH_ACCEPT) || authResult.equals((Object)AuthResultEnum.AUTH_ACCEPT_LOC);
    }

    @VisibleForTesting
    synchronized void setNullableUserManager(IUserManager nullableUserManager) {
        this.nullableUserManager = nullableUserManager;
    }
}

