/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util;

import com.google.common.base.Preconditions;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public final class NetconfUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfUtil.class);

    private NetconfUtil() {
    }

    public static Document checkIsMessageOk(Document response) throws NetconfDocumentedException {
        XmlElement element = XmlElement.fromDomDocument(response);
        Preconditions.checkState((boolean)element.getName().equals("rpc-reply"));
        element = element.getOnlyChildElement();
        if (element.getName().equals("ok")) {
            return response;
        }
        LOG.warn("Can not load last configuration. Operation failed.");
        throw new IllegalStateException("Can not load last configuration. Operation failed: " + XmlUtil.toString(response));
    }
}

