/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamAttributeWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public class OrderedNormalizedNodeWriter
implements Closeable,
Flushable {
    private final SchemaContext schemaContext;
    private final SchemaNode root;
    private final NormalizedNodeStreamWriter writer;

    public OrderedNormalizedNodeWriter(NormalizedNodeStreamWriter writer, SchemaContext schemaContext, SchemaPath path) {
        this.writer = writer;
        this.schemaContext = schemaContext;
        this.root = this.findParentSchemaOnPath(schemaContext, path);
    }

    public OrderedNormalizedNodeWriter write(NormalizedNode<?, ?> node) throws IOException {
        if (this.root == this.schemaContext) {
            return this.write(node, (SchemaNode)this.schemaContext.getDataChildByName(node.getNodeType()));
        }
        return this.write(node, this.root);
    }

    public OrderedNormalizedNodeWriter write(Collection<DataContainerChild<?, ?>> nodes) throws IOException {
        if (this.writeChildren(nodes, this.root, false)) {
            return this;
        }
        throw new IllegalStateException("It wasn't possible to serialize nodes " + nodes);
    }

    private OrderedNormalizedNodeWriter write(NormalizedNode<?, ?> node, SchemaNode dataSchemaNode) throws IOException {
        if (node == null) {
            return this;
        }
        if (this.wasProcessedAsCompositeNode(node, dataSchemaNode)) {
            return this;
        }
        if (this.wasProcessAsSimpleNode(node)) {
            return this;
        }
        throw new IllegalStateException("It wasn't possible to serialize node " + node);
    }

    private void write(List<NormalizedNode<?, ?>> nodes, SchemaNode dataSchemaNode) throws IOException {
        for (NormalizedNode<?, ?> node : nodes) {
            this.write(node, dataSchemaNode);
        }
    }

    private OrderedNormalizedNodeWriter writeLeaf(NormalizedNode<?, ?> node) throws IOException {
        if (this.wasProcessAsSimpleNode(node)) {
            return this;
        }
        throw new IllegalStateException("It wasn't possible to serialize node " + node);
    }

    private boolean writeChildren(Iterable<? extends NormalizedNode<?, ?>> children, SchemaNode parentSchemaNode, boolean endParent) throws IOException {
        ArrayListMultimap qNameToNodes = ArrayListMultimap.create();
        for (NormalizedNode<?, ?> normalizedNode : children) {
            if (normalizedNode instanceof AugmentationNode) {
                qNameToNodes.putAll(this.resolveAugmentations(normalizedNode));
                continue;
            }
            qNameToNodes.put((Object)normalizedNode.getNodeType(), normalizedNode);
        }
        if (parentSchemaNode instanceof DataNodeContainer) {
            if (parentSchemaNode instanceof ListSchemaNode && qNameToNodes.containsKey((Object)parentSchemaNode.getQName())) {
                this.write(qNameToNodes.get((Object)parentSchemaNode.getQName()), parentSchemaNode);
            } else {
                for (DataSchemaNode dataSchemaNode : ((DataNodeContainer)parentSchemaNode).getChildNodes()) {
                    this.write(qNameToNodes.get((Object)dataSchemaNode.getQName()), (SchemaNode)dataSchemaNode);
                }
            }
        } else if (parentSchemaNode instanceof ChoiceSchemaNode) {
            for (ChoiceCaseNode choiceCaseNode : ((ChoiceSchemaNode)parentSchemaNode).getCases()) {
                for (DataSchemaNode dsn : choiceCaseNode.getChildNodes()) {
                    if (!qNameToNodes.containsKey((Object)dsn.getQName())) continue;
                    this.write(qNameToNodes.get((Object)dsn.getQName()), (SchemaNode)dsn);
                }
            }
        } else {
            for (NormalizedNode normalizedNode : children) {
                this.writeLeaf(normalizedNode);
            }
        }
        if (endParent) {
            this.writer.endNode();
        }
        return true;
    }

    private ArrayListMultimap<QName, NormalizedNode<?, ?>> resolveAugmentations(NormalizedNode<?, ?> child) {
        ArrayListMultimap resolvedAugs = ArrayListMultimap.create();
        for (NormalizedNode node : ((AugmentationNode)child).getValue()) {
            if (node instanceof AugmentationNode) {
                resolvedAugs.putAll(this.resolveAugmentations(node));
                continue;
            }
            resolvedAugs.put((Object)node.getNodeType(), (Object)node);
        }
        return resolvedAugs;
    }

    private boolean writeMapEntryNode(MapEntryNode node, SchemaNode dataSchemaNode) throws IOException {
        if (this.writer instanceof NormalizedNodeStreamAttributeWriter) {
            ((NormalizedNodeStreamAttributeWriter)this.writer).startMapEntryNode(node.getIdentifier(), OrderedNormalizedNodeWriter.childSizeHint(node.getValue()), node.getAttributes());
        } else {
            this.writer.startMapEntryNode(node.getIdentifier(), OrderedNormalizedNodeWriter.childSizeHint(node.getValue()));
        }
        return this.writeChildren(node.getValue(), dataSchemaNode, true);
    }

    private boolean wasProcessAsSimpleNode(NormalizedNode<?, ?> node) throws IOException {
        if (node instanceof LeafSetEntryNode) {
            LeafSetEntryNode nodeAsLeafList = (LeafSetEntryNode)node;
            if (this.writer instanceof NormalizedNodeStreamAttributeWriter) {
                ((NormalizedNodeStreamAttributeWriter)this.writer).leafSetEntryNode(nodeAsLeafList.getValue(), nodeAsLeafList.getAttributes());
            } else {
                this.writer.leafSetEntryNode(nodeAsLeafList.getValue());
            }
            return true;
        }
        if (node instanceof LeafNode) {
            LeafNode nodeAsLeaf = (LeafNode)node;
            if (this.writer instanceof NormalizedNodeStreamAttributeWriter) {
                ((NormalizedNodeStreamAttributeWriter)this.writer).leafNode((YangInstanceIdentifier.NodeIdentifier)nodeAsLeaf.getIdentifier(), nodeAsLeaf.getValue(), nodeAsLeaf.getAttributes());
            } else {
                this.writer.leafNode((YangInstanceIdentifier.NodeIdentifier)nodeAsLeaf.getIdentifier(), nodeAsLeaf.getValue());
            }
            return true;
        }
        if (node instanceof AnyXmlNode) {
            AnyXmlNode anyXmlNode = (AnyXmlNode)node;
            this.writer.anyxmlNode(anyXmlNode.getIdentifier(), (Object)anyXmlNode.getValue());
            return true;
        }
        return false;
    }

    private boolean wasProcessedAsCompositeNode(NormalizedNode<?, ?> node, SchemaNode dataSchemaNode) throws IOException {
        if (node instanceof ContainerNode) {
            ContainerNode n = (ContainerNode)node;
            if (this.writer instanceof NormalizedNodeStreamAttributeWriter) {
                ((NormalizedNodeStreamAttributeWriter)this.writer).startContainerNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), OrderedNormalizedNodeWriter.childSizeHint(n.getValue()), n.getAttributes());
            } else {
                this.writer.startContainerNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), OrderedNormalizedNodeWriter.childSizeHint(n.getValue()));
            }
            return this.writeChildren(n.getValue(), dataSchemaNode, true);
        }
        if (node instanceof MapEntryNode) {
            return this.writeMapEntryNode((MapEntryNode)node, dataSchemaNode);
        }
        if (node instanceof UnkeyedListEntryNode) {
            UnkeyedListEntryNode n = (UnkeyedListEntryNode)node;
            this.writer.startUnkeyedListItem((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), OrderedNormalizedNodeWriter.childSizeHint(n.getValue()));
            return this.writeChildren(n.getValue(), dataSchemaNode, true);
        }
        if (node instanceof ChoiceNode) {
            ChoiceNode n = (ChoiceNode)node;
            this.writer.startChoiceNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), OrderedNormalizedNodeWriter.childSizeHint(n.getValue()));
            return this.writeChildren(n.getValue(), dataSchemaNode, true);
        }
        if (node instanceof AugmentationNode) {
            AugmentationNode n = (AugmentationNode)node;
            this.writer.startAugmentationNode(n.getIdentifier());
            return this.writeChildren(n.getValue(), dataSchemaNode, true);
        }
        if (node instanceof UnkeyedListNode) {
            UnkeyedListNode n = (UnkeyedListNode)node;
            this.writer.startUnkeyedList((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), OrderedNormalizedNodeWriter.childSizeHint((Iterable)n.getValue()));
            return this.writeChildren((Iterable)n.getValue(), dataSchemaNode, true);
        }
        if (node instanceof OrderedMapNode) {
            OrderedMapNode n = (OrderedMapNode)node;
            this.writer.startOrderedMapNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), OrderedNormalizedNodeWriter.childSizeHint(n.getValue()));
            return this.writeChildren(n.getValue(), dataSchemaNode, true);
        }
        if (node instanceof MapNode) {
            MapNode n = (MapNode)node;
            this.writer.startMapNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), OrderedNormalizedNodeWriter.childSizeHint(n.getValue()));
            return this.writeChildren(n.getValue(), dataSchemaNode, true);
        }
        if (node instanceof LeafSetNode) {
            LeafSetNode n = (LeafSetNode)node;
            this.writer.startLeafSet((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), OrderedNormalizedNodeWriter.childSizeHint(n.getValue()));
            return this.writeChildren(n.getValue(), dataSchemaNode, true);
        }
        return false;
    }

    private static final int childSizeHint(Iterable<?> children) {
        return children instanceof Collection ? ((Collection)children).size() : -1;
    }

    private SchemaNode findParentSchemaOnPath(SchemaContext schemaContext, SchemaPath path) {
        SchemaNode current = (SchemaNode)Preconditions.checkNotNull((Object)schemaContext);
        for (QName qname : path.getPathFromRoot()) {
            DataSchemaNode child;
            if (current instanceof DataNodeContainer) {
                child = ((DataNodeContainer)current).getDataChildByName(qname);
                if (child == null && current instanceof SchemaContext) {
                    child = (SchemaNode)this.tryFindGroupings((SchemaContext)current, qname).orNull();
                }
                if (child == null && current instanceof SchemaContext) {
                    child = (SchemaNode)this.tryFindNotification((SchemaContext)current, qname).or(this.tryFindRpc((SchemaContext)current, qname)).orNull();
                }
            } else if (current instanceof ChoiceSchemaNode) {
                child = ((ChoiceSchemaNode)current).getCaseNodeByName(qname);
            } else if (current instanceof RpcDefinition) {
                switch (qname.getLocalName()) {
                    case "input": {
                        child = ((RpcDefinition)current).getInput();
                        break;
                    }
                    case "output": {
                        child = ((RpcDefinition)current).getOutput();
                        break;
                    }
                    default: {
                        child = null;
                        break;
                    }
                }
            } else {
                throw new IllegalArgumentException(String.format("Schema node %s does not allow children.", current));
            }
            current = child;
        }
        return current;
    }

    private Optional<SchemaNode> tryFindGroupings(SchemaContext ctx, QName qname) {
        return Optional.fromNullable((Object)Iterables.find((Iterable)ctx.getGroupings(), (Predicate)new SchemaNodePredicate(qname), null));
    }

    private Optional<SchemaNode> tryFindRpc(SchemaContext ctx, QName qname) {
        return Optional.fromNullable((Object)Iterables.find((Iterable)ctx.getOperations(), (Predicate)new SchemaNodePredicate(qname), null));
    }

    private Optional<SchemaNode> tryFindNotification(SchemaContext ctx, QName qname) {
        return Optional.fromNullable((Object)Iterables.find((Iterable)ctx.getNotifications(), (Predicate)new SchemaNodePredicate(qname), null));
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    private static final class SchemaNodePredicate
    implements Predicate<SchemaNode> {
        private final QName qname;

        public SchemaNodePredicate(QName qname) {
            this.qname = qname;
        }

        public boolean apply(SchemaNode input) {
            return input.getQName().equals((Object)this.qname);
        }
    }
}

