/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.capability;

import com.google.common.base.Optional;
import org.opendaylight.controller.netconf.util.capability.BasicCapability;
import org.opendaylight.yangtools.yang.common.SimpleDateFormatUtil;
import org.opendaylight.yangtools.yang.model.api.Module;

public final class YangModuleCapability
extends BasicCapability {
    private final String content;
    private final String revision;
    private final String moduleName;
    private final String moduleNamespace;

    public YangModuleCapability(Module module, String moduleContent) {
        super(YangModuleCapability.toCapabilityURI(module));
        this.content = moduleContent;
        this.moduleName = module.getName();
        this.moduleNamespace = module.getNamespace().toString();
        this.revision = SimpleDateFormatUtil.getRevisionFormat().format(module.getRevision());
    }

    @Override
    public Optional<String> getCapabilitySchema() {
        return Optional.of((Object)this.content);
    }

    private static String toCapabilityURI(Module module) {
        return String.valueOf(module.getNamespace()) + "?module=" + module.getName() + "&revision=" + SimpleDateFormatUtil.getRevisionFormat().format(module.getRevision());
    }

    @Override
    public Optional<String> getModuleName() {
        return Optional.of((Object)this.moduleName);
    }

    @Override
    public Optional<String> getModuleNamespace() {
        return Optional.of((Object)this.moduleNamespace);
    }

    @Override
    public Optional<String> getRevision() {
        return Optional.of((Object)this.revision);
    }
}

