/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.mapping;

import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.mapping.api.HandlingPriority;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationChainedExecution;
import org.opendaylight.controller.netconf.util.mapping.AbstractNetconfOperation;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractLastNetconfOperation
extends AbstractNetconfOperation {
    protected AbstractLastNetconfOperation(String netconfSessionIdForReporting) {
        super(netconfSessionIdForReporting);
    }

    @Override
    protected Element handle(Document document, XmlElement operationElement, NetconfOperationChainedExecution subsequentOperation) throws NetconfDocumentedException {
        if (!subsequentOperation.isExecutionTermination()) {
            throw new NetconfDocumentedException(String.format("No netconf operation expected to be subsequent to %s, but is %s", this, subsequentOperation), NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.malformed_message, NetconfDocumentedException.ErrorSeverity.error);
        }
        return this.handleWithNoSubsequentOperations(document, operationElement);
    }

    @Override
    protected HandlingPriority getHandlingPriority() {
        return HandlingPriority.HANDLE_WITH_DEFAULT_PRIORITY;
    }

    protected abstract Element handleWithNoSubsequentOperations(Document var1, XmlElement var2) throws NetconfDocumentedException;
}

