/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.mapping;

import com.google.common.base.Optional;
import java.util.Map;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.mapping.api.HandlingPriority;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperation;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationChainedExecution;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractNetconfOperation
implements NetconfOperation {
    private final String netconfSessionIdForReporting;

    protected AbstractNetconfOperation(String netconfSessionIdForReporting) {
        this.netconfSessionIdForReporting = netconfSessionIdForReporting;
    }

    public final String getNetconfSessionIdForReporting() {
        return this.netconfSessionIdForReporting;
    }

    public HandlingPriority canHandle(Document message) throws NetconfDocumentedException {
        OperationNameAndNamespace operationNameAndNamespace = null;
        operationNameAndNamespace = new OperationNameAndNamespace(message);
        return this.canHandle(operationNameAndNamespace.getOperationName(), operationNameAndNamespace.getNamespace());
    }

    protected static XmlElement getRequestElementWithCheck(Document message) throws NetconfDocumentedException {
        return XmlElement.fromDomElementWithExpected(message.getDocumentElement(), "rpc", "urn:ietf:params:xml:ns:netconf:base:1.0");
    }

    protected HandlingPriority canHandle(String operationName, String operationNamespace) {
        return operationName.equals(this.getOperationName()) && operationNamespace.equals(this.getOperationNamespace()) ? this.getHandlingPriority() : HandlingPriority.CANNOT_HANDLE;
    }

    protected HandlingPriority getHandlingPriority() {
        return HandlingPriority.HANDLE_WITH_DEFAULT_PRIORITY;
    }

    protected String getOperationNamespace() {
        return "urn:ietf:params:xml:ns:netconf:base:1.0";
    }

    protected abstract String getOperationName();

    public Document handle(Document requestMessage, NetconfOperationChainedExecution subsequentOperation) throws NetconfDocumentedException {
        XmlElement requestElement = AbstractNetconfOperation.getRequestElementWithCheck(requestMessage);
        Document document = XmlUtil.newDocument();
        XmlElement operationElement = requestElement.getOnlyChildElement();
        Map<String, Attr> attributes = requestElement.getAttributes();
        Element response = this.handle(document, operationElement, subsequentOperation);
        Element rpcReply = XmlUtil.createElement(document, "rpc-reply", (Optional<String>)Optional.of((Object)"urn:ietf:params:xml:ns:netconf:base:1.0"));
        if (XmlElement.fromDomElement(response).hasNamespace()) {
            rpcReply.appendChild(response);
        } else {
            Element responseNS = XmlUtil.createElement(document, response.getNodeName(), (Optional<String>)Optional.of((Object)"urn:ietf:params:xml:ns:netconf:base:1.0"));
            NodeList list = response.getChildNodes();
            while (list.getLength() != 0) {
                responseNS.appendChild(list.item(0));
            }
            rpcReply.appendChild(responseNS);
        }
        for (Attr attribute : attributes.values()) {
            rpcReply.setAttributeNode((Attr)document.importNode(attribute, true));
        }
        document.appendChild(rpcReply);
        return document;
    }

    protected abstract Element handle(Document var1, XmlElement var2, NetconfOperationChainedExecution var3) throws NetconfDocumentedException;

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        try {
            sb.append("{name=").append(this.getOperationName());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        sb.append(", namespace=").append(this.getOperationNamespace());
        sb.append(", session=").append(this.netconfSessionIdForReporting);
        sb.append('}');
        return sb.toString();
    }

    public static final class OperationNameAndNamespace {
        private final String operationName;
        private final String namespace;
        private final XmlElement operationElement;

        public OperationNameAndNamespace(Document message) throws NetconfDocumentedException {
            XmlElement requestElement = null;
            requestElement = AbstractNetconfOperation.getRequestElementWithCheck(message);
            this.operationElement = requestElement.getOnlyChildElement();
            this.operationName = this.operationElement.getName();
            this.namespace = this.operationElement.getNamespace();
        }

        public String getOperationName() {
            return this.operationName;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public XmlElement getOperationElement() {
            return this.operationElement;
        }
    }
}

