/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.messages;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.util.exception.MissingNameSpaceException;
import org.opendaylight.controller.netconf.util.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class NetconfHelloMessage
extends NetconfMessage {
    public static final String HELLO_TAG = "hello";
    private final NetconfHelloMessageAdditionalHeader additionalHeader;

    public NetconfHelloMessage(Document doc, NetconfHelloMessageAdditionalHeader additionalHeader) throws NetconfDocumentedException {
        super(doc);
        NetconfHelloMessage.checkHelloMessage(doc);
        this.additionalHeader = additionalHeader;
    }

    public NetconfHelloMessage(Document doc) throws NetconfDocumentedException {
        this(doc, null);
    }

    public Optional<NetconfHelloMessageAdditionalHeader> getAdditionalHeader() {
        return this.additionalHeader == null ? Optional.absent() : Optional.of((Object)this.additionalHeader);
    }

    private static void checkHelloMessage(Document doc) {
        Preconditions.checkArgument((boolean)NetconfHelloMessage.isHelloMessage(doc), (String)"Hello message invalid format, should contain %s tag from namespace %s, but is: %s", (Object[])new Object[]{HELLO_TAG, "urn:ietf:params:xml:ns:netconf:base:1.0", XmlUtil.toString(doc)});
    }

    public static NetconfHelloMessage createClientHello(Iterable<String> capabilities, Optional<NetconfHelloMessageAdditionalHeader> additionalHeaderOptional) throws NetconfDocumentedException {
        Document doc = NetconfHelloMessage.createHelloMessageDoc(capabilities);
        return additionalHeaderOptional.isPresent() ? new NetconfHelloMessage(doc, (NetconfHelloMessageAdditionalHeader)additionalHeaderOptional.get()) : new NetconfHelloMessage(doc);
    }

    private static Document createHelloMessageDoc(Iterable<String> capabilities) {
        Document doc = XmlUtil.newDocument();
        Element helloElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", HELLO_TAG);
        Element capabilitiesElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "capabilities");
        for (String capability : Sets.newHashSet(capabilities)) {
            Element capElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "capability");
            capElement.setTextContent(capability);
            capabilitiesElement.appendChild(capElement);
        }
        helloElement.appendChild(capabilitiesElement);
        doc.appendChild(helloElement);
        return doc;
    }

    public static NetconfHelloMessage createServerHello(Set<String> capabilities, long sessionId) throws NetconfDocumentedException {
        Document doc = NetconfHelloMessage.createHelloMessageDoc(capabilities);
        Element sessionIdElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "session-id");
        sessionIdElement.setTextContent(Long.toString(sessionId));
        doc.getDocumentElement().appendChild(sessionIdElement);
        return new NetconfHelloMessage(doc);
    }

    public static boolean isHelloMessage(NetconfMessage msg) {
        Document document = msg.getDocument();
        return NetconfHelloMessage.isHelloMessage(document);
    }

    private static boolean isHelloMessage(Document document) {
        XmlElement element = XmlElement.fromDomElement(document.getDocumentElement());
        try {
            return element.getName().equals(HELLO_TAG) && (!element.hasNamespace() || element.getNamespace().equals("urn:ietf:params:xml:ns:netconf:base:1.0"));
        }
        catch (MissingNameSpaceException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
    }
}

