/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.messages;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public final class NetconfMessageUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfMessageUtil.class);

    private NetconfMessageUtil() {
    }

    public static boolean isOKMessage(NetconfMessage message) throws NetconfDocumentedException {
        return NetconfMessageUtil.isOKMessage(message.getDocument());
    }

    public static boolean isOKMessage(Document document) throws NetconfDocumentedException {
        return NetconfMessageUtil.isOKMessage(XmlElement.fromDomDocument(document));
    }

    public static boolean isOKMessage(XmlElement xmlElement) throws NetconfDocumentedException {
        if (xmlElement.getChildElements().size() != 1) {
            return false;
        }
        return xmlElement.getOnlyChildElement().getName().equals("ok");
    }

    public static boolean isErrorMessage(NetconfMessage message) throws NetconfDocumentedException {
        return NetconfMessageUtil.isErrorMessage(message.getDocument());
    }

    public static boolean isErrorMessage(Document document) throws NetconfDocumentedException {
        return NetconfMessageUtil.isErrorMessage(XmlElement.fromDomDocument(document));
    }

    public static boolean isErrorMessage(XmlElement xmlElement) throws NetconfDocumentedException {
        if (xmlElement.getChildElements().size() != 1) {
            return false;
        }
        return xmlElement.getOnlyChildElement().getName().equals("rpc-error");
    }

    public static Collection<String> extractCapabilitiesFromHello(Document doc) throws NetconfDocumentedException {
        XmlElement responseElement = XmlElement.fromDomDocument(doc);
        Optional capabilitiesElement = responseElement.getOnlyChildElementWithSameNamespaceOptionally("capabilities").or(responseElement.getOnlyChildElementOptionally("capabilities"));
        List<XmlElement> caps = ((XmlElement)capabilitiesElement.get()).getChildElements("capability");
        return Collections2.transform(caps, (Function)new Function<XmlElement, String>(){

            public String apply(@Nonnull XmlElement input) {
                try {
                    return input.getTextContent().trim();
                }
                catch (NetconfDocumentedException e) {
                    LOG.trace("Error fetching input text content", (Throwable)e);
                    return null;
                }
            }
        });
    }
}

