/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.messages;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.api.NetconfSession;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public final class SendErrorExceptionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SendErrorExceptionUtil.class);

    private SendErrorExceptionUtil() {
    }

    public static void sendErrorMessage(NetconfSession session, NetconfDocumentedException sendErrorException) {
        LOG.trace("Sending error {}", (Object)sendErrorException.getMessage(), (Object)sendErrorException);
        Document errorDocument = SendErrorExceptionUtil.createDocument(sendErrorException);
        ChannelFuture f = session.sendMessage(new NetconfMessage(errorDocument));
        f.addListener((GenericFutureListener)new SendErrorVerifyingListener(sendErrorException));
    }

    public static void sendErrorMessage(Channel channel, NetconfDocumentedException sendErrorException) {
        LOG.trace("Sending error {}", (Object)sendErrorException.getMessage(), (Object)sendErrorException);
        Document errorDocument = SendErrorExceptionUtil.createDocument(sendErrorException);
        ChannelFuture f = channel.writeAndFlush((Object)new NetconfMessage(errorDocument));
        f.addListener((GenericFutureListener)new SendErrorVerifyingListener(sendErrorException));
    }

    public static void sendErrorMessage(NetconfSession session, NetconfDocumentedException sendErrorException, NetconfMessage incommingMessage) {
        Document errorDocument = SendErrorExceptionUtil.createDocument(sendErrorException);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sending error {}", (Object)XmlUtil.toString(errorDocument));
        }
        SendErrorExceptionUtil.tryToCopyAttributes(incommingMessage.getDocument(), errorDocument, sendErrorException);
        ChannelFuture f = session.sendMessage(new NetconfMessage(errorDocument));
        f.addListener((GenericFutureListener)new SendErrorVerifyingListener(sendErrorException));
    }

    private static void tryToCopyAttributes(Document incommingDocument, Document errorDocument, NetconfDocumentedException sendErrorException) {
        try {
            Element incommingRpc = incommingDocument.getDocumentElement();
            Preconditions.checkState((boolean)incommingRpc.getTagName().equals("rpc"), (String)"Missing %s element", (Object[])new Object[]{"rpc"});
            Element rpcReply = errorDocument.getDocumentElement();
            Preconditions.checkState((boolean)rpcReply.getTagName().equals("rpc-reply"), (String)"Missing %s element", (Object[])new Object[]{"rpc-reply"});
            NamedNodeMap incomingAttributes = incommingRpc.getAttributes();
            for (int i = 0; i < incomingAttributes.getLength(); ++i) {
                Attr attr = (Attr)incomingAttributes.item(i);
                if (attr.getNodeName().equals("xmlns")) continue;
                rpcReply.setAttributeNode((Attr)errorDocument.importNode(attr, true));
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to copy incomming attributes to {}, returned rpc-error might be invalid for client", (Object)sendErrorException, (Object)e);
        }
    }

    private static Document createDocument(NetconfDocumentedException sendErrorException) {
        return sendErrorException.toXMLDocument();
    }

    private static final class SendErrorVerifyingListener
    implements ChannelFutureListener {
        private final NetconfDocumentedException sendErrorException;

        public SendErrorVerifyingListener(NetconfDocumentedException sendErrorException) {
            this.sendErrorException = sendErrorException;
        }

        public void operationComplete(ChannelFuture channelFuture) throws Exception {
            Preconditions.checkState((boolean)channelFuture.isSuccess(), (String)"Unable to send exception %s", (Object[])new Object[]{this.sendErrorException, channelFuture.cause()});
        }
    }
}

