/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.osgi;

import com.google.common.base.Optional;
import io.netty.channel.local.LocalAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfConfigUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfConfigUtil.class);
    private static final String PREFIX_PROP = "netconf.";
    private static final String PORT_SUFFIX_PROP = ".port";
    private static final String ADDRESS_SUFFIX_PROP = ".address";
    private static final String PRIVATE_KEY_PATH_PROP = ".pk.path";
    private static final String CONNECTION_TIMEOUT_MILLIS_PROP = "connectionTimeoutMillis";
    public static final long DEFAULT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    private static final LocalAddress netconfLocalAddress = new LocalAddress("netconf");

    private NetconfConfigUtil() {
    }

    public static LocalAddress getNetconfLocalAddress() {
        return netconfLocalAddress;
    }

    public static long extractTimeoutMillis(BundleContext bundleContext) {
        String key = "netconf.connectionTimeoutMillis";
        String timeoutString = bundleContext.getProperty("netconf.connectionTimeoutMillis");
        if (timeoutString == null || timeoutString.length() == 0) {
            return DEFAULT_TIMEOUT_MILLIS;
        }
        try {
            return Long.parseLong(timeoutString);
        }
        catch (NumberFormatException e) {
            LOG.warn("Cannot parse {} property: {}, using defaults", new Object[]{"netconf.connectionTimeoutMillis", timeoutString, e});
            return DEFAULT_TIMEOUT_MILLIS;
        }
    }

    public static String getPrivateKeyPath(BundleContext context) {
        return NetconfConfigUtil.getPropertyValue(context, NetconfConfigUtil.getPrivateKeyKey());
    }

    public static String getPrivateKeyKey() {
        return PREFIX_PROP + (Object)((Object)InfixProp.ssh) + PRIVATE_KEY_PATH_PROP;
    }

    private static String getPropertyValue(BundleContext context, String propertyName) {
        String propertyValue = context.getProperty(propertyName);
        if (propertyValue == null) {
            throw new IllegalStateException("Cannot find initial property with name '" + propertyName + "'");
        }
        return propertyValue;
    }

    public static String getNetconfServerAddressKey(InfixProp infixProp) {
        return PREFIX_PROP + (Object)((Object)infixProp) + ADDRESS_SUFFIX_PROP;
    }

    public static Optional<InetSocketAddress> extractNetconfServerAddress(BundleContext context, InfixProp infixProp) {
        Optional<String> address = NetconfConfigUtil.getProperty(context, NetconfConfigUtil.getNetconfServerAddressKey(infixProp));
        Optional<String> port = NetconfConfigUtil.getProperty(context, PREFIX_PROP + (Object)((Object)infixProp) + PORT_SUFFIX_PROP);
        if (address.isPresent() && port.isPresent()) {
            try {
                return Optional.of((Object)NetconfConfigUtil.parseAddress(address, port));
            }
            catch (RuntimeException e) {
                LOG.warn("Unable to parse {} netconf address from {}:{}, fallback to default", new Object[]{infixProp, address, port, e});
            }
        }
        return Optional.absent();
    }

    private static InetSocketAddress parseAddress(Optional<String> address, Optional<String> port) {
        int portNumber = Integer.valueOf((String)port.get());
        return new InetSocketAddress((String)address.get(), portNumber);
    }

    private static Optional<String> getProperty(BundleContext context, String propKey) {
        String value = context.getProperty(propKey);
        if (value != null && value.isEmpty()) {
            value = null;
        }
        return Optional.fromNullable((Object)value);
    }

    public static enum InfixProp {
        tcp,
        ssh;

    }
}

