/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.xml;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.util.exception.MissingNameSpaceException;
import org.opendaylight.controller.netconf.util.exception.UnexpectedElementException;
import org.opendaylight.controller.netconf.util.exception.UnexpectedNamespaceException;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public final class XmlElement {
    public static final String DEFAULT_NAMESPACE_PREFIX = "";
    private final Element element;
    private static final Logger LOG = LoggerFactory.getLogger(XmlElement.class);

    private XmlElement(Element element) {
        this.element = element;
    }

    public static XmlElement fromDomElement(Element e) {
        return new XmlElement(e);
    }

    public static XmlElement fromDomDocument(Document xml) {
        return new XmlElement(xml.getDocumentElement());
    }

    public static XmlElement fromString(String s) throws NetconfDocumentedException {
        try {
            return new XmlElement(XmlUtil.readXmlToElement(s));
        }
        catch (IOException | SAXException e) {
            throw NetconfDocumentedException.wrap((Exception)e);
        }
    }

    public static XmlElement fromDomElementWithExpected(Element element, String expectedName) throws NetconfDocumentedException {
        XmlElement xmlElement = XmlElement.fromDomElement(element);
        xmlElement.checkName(expectedName);
        return xmlElement;
    }

    public static XmlElement fromDomElementWithExpected(Element element, String expectedName, String expectedNamespace) throws NetconfDocumentedException {
        XmlElement xmlElement = XmlElement.fromDomElementWithExpected(element, expectedName);
        xmlElement.checkNamespace(expectedNamespace);
        return xmlElement;
    }

    private Map<String, String> extractNamespaces() throws NetconfDocumentedException {
        Optional<String> namespaceOptionally;
        HashMap<String, String> namespaces = new HashMap<String, String>();
        NamedNodeMap attributes = this.element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String prefix;
            Node attribute = attributes.item(i);
            String attribKey = attribute.getNodeName();
            if (!attribKey.startsWith("xmlns")) continue;
            if (attribKey.equals("xmlns")) {
                prefix = DEFAULT_NAMESPACE_PREFIX;
            } else {
                if (!attribKey.startsWith("xmlns:")) {
                    throw new NetconfDocumentedException("Attribute doesn't start with :", NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.invalid_value, NetconfDocumentedException.ErrorSeverity.error);
                }
                prefix = attribKey.substring("xmlns".length() + 1);
            }
            namespaces.put(prefix, attribute.getNodeValue());
        }
        if (!namespaces.containsKey(DEFAULT_NAMESPACE_PREFIX) && (namespaceOptionally = this.getNamespaceOptionally()).isPresent()) {
            namespaces.put(DEFAULT_NAMESPACE_PREFIX, (String)namespaceOptionally.get());
        }
        return namespaces;
    }

    public void checkName(String expectedName) throws UnexpectedElementException {
        if (!this.getName().equals(expectedName)) {
            throw new UnexpectedElementException(String.format("Expected %s xml element but was %s", expectedName, this.getName()), NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_failed, NetconfDocumentedException.ErrorSeverity.error);
        }
    }

    public void checkNamespaceAttribute(String expectedNamespace) throws UnexpectedNamespaceException, MissingNameSpaceException {
        if (!this.getNamespaceAttribute().equals(expectedNamespace)) {
            throw new UnexpectedNamespaceException(String.format("Unexpected namespace %s should be %s", this.getNamespaceAttribute(), expectedNamespace), NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_failed, NetconfDocumentedException.ErrorSeverity.error);
        }
    }

    public void checkNamespace(String expectedNamespace) throws UnexpectedNamespaceException, MissingNameSpaceException {
        if (!this.getNamespace().equals(expectedNamespace)) {
            throw new UnexpectedNamespaceException(String.format("Unexpected namespace %s should be %s", this.getNamespace(), expectedNamespace), NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_failed, NetconfDocumentedException.ErrorSeverity.error);
        }
    }

    public String getName() {
        String localName = this.element.getLocalName();
        if (!Strings.isNullOrEmpty((String)localName)) {
            return localName;
        }
        return this.element.getTagName();
    }

    public String getAttribute(String attributeName) {
        return this.element.getAttribute(attributeName);
    }

    public String getAttribute(String attributeName, String namespace) {
        return this.element.getAttributeNS(namespace, attributeName);
    }

    public NodeList getElementsByTagName(String name) {
        return this.element.getElementsByTagName(name);
    }

    public void appendChild(Element element) {
        this.element.appendChild(element);
    }

    public Element getDomElement() {
        return this.element;
    }

    public Map<String, Attr> getAttributes() {
        HashMap mappedAttributes = Maps.newHashMap();
        NamedNodeMap attributes = this.element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            mappedAttributes.put(attr.getNodeName(), attr);
        }
        return mappedAttributes;
    }

    private List<XmlElement> getChildElementsInternal(ElementFilteringStrategy strat) {
        NodeList childNodes = this.element.getChildNodes();
        ArrayList<XmlElement> result = new ArrayList<XmlElement>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!(item instanceof Element) || !strat.accept((Element)item)) continue;
            result.add(new XmlElement((Element)item));
        }
        return result;
    }

    public List<XmlElement> getChildElements() {
        return this.getChildElementsInternal(new ElementFilteringStrategy(){

            @Override
            public boolean accept(Element e) {
                return true;
            }
        });
    }

    public List<XmlElement> getChildElementsWithinNamespace(final String childName, String namespace) {
        return Lists.newArrayList((Iterable)Collections2.filter(this.getChildElementsWithinNamespace(namespace), (Predicate)new Predicate<XmlElement>(){

            public boolean apply(XmlElement xmlElement) {
                return xmlElement.getName().equals(childName);
            }
        }));
    }

    public List<XmlElement> getChildElementsWithinNamespace(final String namespace) {
        return this.getChildElementsInternal(new ElementFilteringStrategy(){

            @Override
            public boolean accept(Element e) {
                try {
                    return XmlElement.fromDomElement(e).getNamespace().equals(namespace);
                }
                catch (MissingNameSpaceException e1) {
                    return false;
                }
            }
        });
    }

    public List<XmlElement> getChildElements(final String tagName) {
        return this.getChildElementsInternal(new ElementFilteringStrategy(){

            @Override
            public boolean accept(Element e) {
                return e.getLocalName().equals(tagName);
            }
        });
    }

    public XmlElement getOnlyChildElement(String childName) throws NetconfDocumentedException {
        List<XmlElement> nameElements = this.getChildElements(childName);
        if (nameElements.size() != 1) {
            throw new NetconfDocumentedException("One element " + childName + " expected in " + this.toString(), NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.invalid_value, NetconfDocumentedException.ErrorSeverity.error);
        }
        return nameElements.get(0);
    }

    public Optional<XmlElement> getOnlyChildElementOptionally(String childName) {
        List<XmlElement> nameElements = this.getChildElements(childName);
        if (nameElements.size() != 1) {
            return Optional.absent();
        }
        return Optional.of((Object)nameElements.get(0));
    }

    public Optional<XmlElement> getOnlyChildElementOptionally(final String childName, String namespace) {
        ArrayList children = this.getChildElementsWithinNamespace(namespace);
        if ((children = Lists.newArrayList((Iterable)Collections2.filter(children, (Predicate)new Predicate<XmlElement>(){

            public boolean apply(XmlElement xmlElement) {
                return xmlElement.getName().equals(childName);
            }
        }))).size() != 1) {
            return Optional.absent();
        }
        return Optional.of(children.get(0));
    }

    public XmlElement getOnlyChildElementWithSameNamespace(String childName) throws NetconfDocumentedException {
        return this.getOnlyChildElement(childName, this.getNamespace());
    }

    public Optional<XmlElement> getOnlyChildElementWithSameNamespaceOptionally(final String childName) {
        Optional<String> namespace = this.getNamespaceOptionally();
        if (namespace.isPresent()) {
            ArrayList children = this.getChildElementsWithinNamespace((String)namespace.get());
            if ((children = Lists.newArrayList((Iterable)Collections2.filter(children, (Predicate)new Predicate<XmlElement>(){

                public boolean apply(XmlElement xmlElement) {
                    return xmlElement.getName().equals(childName);
                }
            }))).size() != 1) {
                return Optional.absent();
            }
            return Optional.of(children.get(0));
        }
        return Optional.absent();
    }

    public XmlElement getOnlyChildElementWithSameNamespace() throws NetconfDocumentedException {
        XmlElement childElement = this.getOnlyChildElement();
        childElement.checkNamespace(this.getNamespace());
        return childElement;
    }

    public Optional<XmlElement> getOnlyChildElementWithSameNamespaceOptionally() {
        Optional<XmlElement> child = this.getOnlyChildElementOptionally();
        if (child.isPresent() && ((XmlElement)child.get()).getNamespaceOptionally().isPresent() && this.getNamespaceOptionally().isPresent() && ((String)this.getNamespaceOptionally().get()).equals(((XmlElement)child.get()).getNamespaceOptionally().get())) {
            return child;
        }
        return Optional.absent();
    }

    public XmlElement getOnlyChildElement(final String childName, String namespace) throws NetconfDocumentedException {
        ArrayList children = this.getChildElementsWithinNamespace(namespace);
        if ((children = Lists.newArrayList((Iterable)Collections2.filter(children, (Predicate)new Predicate<XmlElement>(){

            public boolean apply(XmlElement xmlElement) {
                return xmlElement.getName().equals(childName);
            }
        }))).size() != 1) {
            throw new NetconfDocumentedException(String.format("One element %s:%s expected in %s but was %s", namespace, childName, this.toString(), children.size()), NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.invalid_value, NetconfDocumentedException.ErrorSeverity.error);
        }
        return (XmlElement)children.get(0);
    }

    public XmlElement getOnlyChildElement() throws NetconfDocumentedException {
        List<XmlElement> children = this.getChildElements();
        if (children.size() != 1) {
            throw new NetconfDocumentedException(String.format("One element expected in %s but was %s", this.toString(), children.size()), NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.invalid_value, NetconfDocumentedException.ErrorSeverity.error);
        }
        return children.get(0);
    }

    public Optional<XmlElement> getOnlyChildElementOptionally() {
        List<XmlElement> children = this.getChildElements();
        if (children.size() != 1) {
            return Optional.absent();
        }
        return Optional.of((Object)children.get(0));
    }

    public String getTextContent() throws NetconfDocumentedException {
        NodeList childNodes = this.element.getChildNodes();
        if (childNodes.getLength() == 0) {
            return DEFAULT_NAMESPACE_PREFIX;
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node textChild = childNodes.item(i);
            if (!(textChild instanceof Text)) continue;
            String content = textChild.getTextContent();
            return content.trim();
        }
        throw new NetconfDocumentedException(this.getName() + " should contain text.", NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.invalid_value, NetconfDocumentedException.ErrorSeverity.error);
    }

    public Optional<String> getOnlyTextContentOptionally() {
        Node item;
        if (this.element.getChildNodes().getLength() == 1 && (item = this.element.getChildNodes().item(0)) instanceof Text) {
            return Optional.of((Object)((Text)item).getWholeText());
        }
        return Optional.absent();
    }

    public String getNamespaceAttribute() throws MissingNameSpaceException {
        String attribute = this.element.getAttribute("xmlns");
        if (attribute == null || attribute.equals(DEFAULT_NAMESPACE_PREFIX)) {
            throw new MissingNameSpaceException(String.format("Element %s must specify namespace", this.toString()), NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_failed, NetconfDocumentedException.ErrorSeverity.error);
        }
        return attribute;
    }

    public Optional<String> getNamespaceAttributeOptionally() {
        String attribute = this.element.getAttribute("xmlns");
        if (attribute == null || attribute.equals(DEFAULT_NAMESPACE_PREFIX)) {
            return Optional.absent();
        }
        return Optional.of((Object)attribute);
    }

    public Optional<String> getNamespaceOptionally() {
        String namespaceURI = this.element.getNamespaceURI();
        if (Strings.isNullOrEmpty((String)namespaceURI)) {
            return Optional.absent();
        }
        return Optional.of((Object)namespaceURI);
    }

    public String getNamespace() throws MissingNameSpaceException {
        Optional<String> namespaceURI = this.getNamespaceOptionally();
        if (!namespaceURI.isPresent()) {
            throw new MissingNameSpaceException(String.format("No namespace defined for %s", this), NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_failed, NetconfDocumentedException.ErrorSeverity.error);
        }
        return (String)namespaceURI.get();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("XmlElement{");
        sb.append("name='").append(this.getName()).append('\'');
        if (this.element.getNamespaceURI() != null) {
            try {
                sb.append(", namespace='").append(this.getNamespace()).append('\'');
            }
            catch (MissingNameSpaceException e) {
                LOG.trace("Missing namespace for element.");
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public Map.Entry<String, String> findNamespaceOfTextContent() throws NetconfDocumentedException {
        String textContent;
        int indexOfColon;
        String prefix;
        Map<String, String> namespaces = this.extractNamespaces();
        if (!namespaces.containsKey(prefix = (indexOfColon = (textContent = this.getTextContent()).indexOf(58)) > -1 ? textContent.substring(0, indexOfColon) : DEFAULT_NAMESPACE_PREFIX)) {
            throw new IllegalArgumentException("Cannot find namespace for " + XmlUtil.toString(this.element) + ". Prefix from content is " + prefix + ". Found namespaces " + namespaces);
        }
        return Maps.immutableEntry((Object)prefix, (Object)namespaces.get(prefix));
    }

    public List<XmlElement> getChildElementsWithSameNamespace(final String childName) throws MissingNameSpaceException {
        List<XmlElement> children = this.getChildElementsWithinNamespace(this.getNamespace());
        return Lists.newArrayList((Iterable)Collections2.filter(children, (Predicate)new Predicate<XmlElement>(){

            public boolean apply(XmlElement xmlElement) {
                return xmlElement.getName().equals(childName);
            }
        }));
    }

    public void checkUnrecognisedElements(List<XmlElement> recognisedElements, XmlElement ... additionalRecognisedElements) throws NetconfDocumentedException {
        List<XmlElement> childElements = this.getChildElements();
        childElements.removeAll(recognisedElements);
        for (XmlElement additionalRecognisedElement : additionalRecognisedElements) {
            childElements.remove(additionalRecognisedElement);
        }
        if (!childElements.isEmpty()) {
            throw new NetconfDocumentedException(String.format("Unrecognised elements %s in %s", childElements, this), NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.invalid_value, NetconfDocumentedException.ErrorSeverity.error);
        }
    }

    public void checkUnrecognisedElements(XmlElement ... additionalRecognisedElements) throws NetconfDocumentedException {
        this.checkUnrecognisedElements(Collections.emptyList(), additionalRecognisedElements);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlElement that = (XmlElement)o;
        return this.element.isEqualNode(that.element);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public boolean hasNamespace() {
        return this.getNamespaceAttributeOptionally().isPresent() || this.getNamespaceOptionally().isPresent();
    }

    private static interface ElementFilteringStrategy {
        public boolean accept(Element var1);
    }
}

