/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.xml;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class XmlUtil {
    public static final String XMLNS_ATTRIBUTE_KEY = "xmlns";
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static final DocumentBuilderFactory BUILDER_FACTORY;
    private static final TransformerFactory TRANSFORMER_FACTORY;
    private static final SchemaFactory SCHEMA_FACTORY;
    private static final ThreadLocal<DocumentBuilder> DEFAULT_DOM_BUILDER;

    private XmlUtil() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static Element readXmlToElement(String xmlContent) throws SAXException, IOException {
        Document doc = XmlUtil.readXmlToDocument(xmlContent);
        return doc.getDocumentElement();
    }

    public static Element readXmlToElement(InputStream xmlContent) throws SAXException, IOException {
        Document doc = XmlUtil.readXmlToDocument(xmlContent);
        return doc.getDocumentElement();
    }

    public static Document readXmlToDocument(String xmlContent) throws SAXException, IOException {
        return XmlUtil.readXmlToDocument(new ByteArrayInputStream(xmlContent.getBytes(Charsets.UTF_8)));
    }

    public static Document readXmlToDocument(InputStream xmlContent) throws SAXException, IOException {
        Document doc = DEFAULT_DOM_BUILDER.get().parse(xmlContent);
        doc.getDocumentElement().normalize();
        return doc;
    }

    public static Element readXmlToElement(File xmlFile) throws SAXException, IOException {
        return XmlUtil.readXmlToDocument(new FileInputStream(xmlFile)).getDocumentElement();
    }

    public static Document newDocument() {
        return DEFAULT_DOM_BUILDER.get().newDocument();
    }

    public static Element createElement(Document document, String qName, Optional<String> namespaceURI) {
        if (namespaceURI.isPresent()) {
            Element element = document.createElementNS((String)namespaceURI.get(), qName);
            String name = XMLNS_ATTRIBUTE_KEY;
            if (element.getPrefix() != null) {
                name = name + ":" + element.getPrefix();
            }
            element.setAttributeNS(XMLNS_URI, name, (String)namespaceURI.get());
            return element;
        }
        return document.createElement(qName);
    }

    public static Element createTextElement(Document document, String qName, String content, Optional<String> namespaceURI) {
        Element typeElement = XmlUtil.createElement(document, qName, namespaceURI);
        typeElement.appendChild(document.createTextNode(content));
        return typeElement;
    }

    public static Element createTextElementWithNamespacedContent(Document document, String qName, String prefix, String namespace, String contentWithoutPrefix) {
        return XmlUtil.createTextElementWithNamespacedContent(document, qName, prefix, namespace, contentWithoutPrefix, (Optional<String>)Optional.absent());
    }

    public static Element createTextElementWithNamespacedContent(Document document, String qName, String prefix, String namespace, String contentWithoutPrefix, Optional<String> namespaceURI) {
        String content = XmlUtil.createPrefixedValue("prefix", contentWithoutPrefix);
        Element element = XmlUtil.createTextElement(document, qName, content, namespaceURI);
        String prefixedNamespaceAttr = XmlUtil.createPrefixedValue(XMLNS_ATTRIBUTE_KEY, prefix);
        element.setAttributeNS(XMLNS_URI, prefixedNamespaceAttr, namespace);
        return element;
    }

    public static String createPrefixedValue(String prefix, String value) {
        return prefix + ":" + value;
    }

    public static String toString(Document document) {
        return XmlUtil.toString(document.getDocumentElement());
    }

    public static String toString(Element xml) {
        return XmlUtil.toString(xml, false);
    }

    public static String toString(XmlElement xmlElement) {
        return XmlUtil.toString(xmlElement.getDomElement(), false);
    }

    public static String toString(Element xml, boolean addXmlDeclaration) {
        try {
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", addXmlDeclaration ? "no" : "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(xml);
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (Exception | TransformerFactoryConfigurationError e) {
            throw new IllegalStateException("Unable to serialize xml element " + xml, e);
        }
    }

    public static String toString(Document doc, boolean addXmlDeclaration) {
        return XmlUtil.toString(doc.getDocumentElement(), addXmlDeclaration);
    }

    public static Schema loadSchema(InputStream ... fromStreams) {
        Source[] sources = new Source[fromStreams.length];
        int i = 0;
        for (InputStream stream : fromStreams) {
            sources[i++] = new StreamSource(stream);
        }
        try {
            return SCHEMA_FACTORY.newSchema(sources);
        }
        catch (SAXException e) {
            throw new IllegalStateException("Failed to instantiate XML schema", e);
        }
    }

    public static Object evaluateXPath(XPathExpression expr, Object rootNode, QName returnType) {
        try {
            return expr.evaluate(rootNode, returnType);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("Error while evaluating xpath expression " + expr, e);
        }
    }

    public static Document createDocumentCopy(Document original) {
        Document copiedDocument = XmlUtil.newDocument();
        Node copiedRoot = copiedDocument.importNode(original.getDocumentElement(), true);
        copiedDocument.appendChild(copiedRoot);
        return copiedDocument;
    }

    static {
        TRANSFORMER_FACTORY = TransformerFactory.newInstance();
        SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            factory.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
        factory.setNamespaceAware(true);
        factory.setCoalescing(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        BUILDER_FACTORY = factory;
        DEFAULT_DOM_BUILDER = new ThreadLocal<DocumentBuilder>(){

            @Override
            protected DocumentBuilder initialValue() {
                try {
                    return BUILDER_FACTORY.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    throw new IllegalStateException("Failed to create threadLocal dom builder", e);
                }
            }

            @Override
            public void set(DocumentBuilder value) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

