/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.netty.timer;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.yang.netty.TimerServiceInterface;
import org.opendaylight.controller.config.yang.netty.timer.HashedWheelTimerModuleMXBean;
import org.opendaylight.controller.config.yang.threadpool.ThreadFactoryServiceInterface;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(namespace="urn:opendaylight:params:xml:ns:yang:controller:netty:timer", name="netty-timer", revision="2013-11-19")
public abstract class AbstractHashedWheelTimerModule
extends AbstractModule<AbstractHashedWheelTimerModule>
implements HashedWheelTimerModuleMXBean,
TimerServiceInterface {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHashedWheelTimerModule.class);
    public static final JmxAttribute threadFactoryJmxAttribute = new JmxAttribute("ThreadFactory");
    private ObjectName threadFactory;
    public static final JmxAttribute tickDurationJmxAttribute = new JmxAttribute("TickDuration");
    private Long tickDuration;
    public static final JmxAttribute ticksPerWheelJmxAttribute = new JmxAttribute("TicksPerWheel");
    private Integer ticksPerWheel;
    private ThreadFactory threadFactoryDependency;

    public AbstractHashedWheelTimerModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractHashedWheelTimerModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractHashedWheelTimerModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public void validate() {
        if (this.threadFactory != null) {
            this.dependencyResolver.validateDependency(ThreadFactoryServiceInterface.class, this.threadFactory, threadFactoryJmxAttribute);
        }
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final ThreadFactory getThreadFactoryDependency() {
        return this.threadFactoryDependency;
    }

    protected final void resolveDependencies() {
        if (this.threadFactory != null) {
            this.threadFactoryDependency = (ThreadFactory)this.dependencyResolver.resolveInstance(ThreadFactory.class, this.threadFactory, threadFactoryJmxAttribute);
        }
    }

    public boolean canReuseInstance(AbstractHashedWheelTimerModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractHashedWheelTimerModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.threadFactory, other.threadFactory)) {
            return false;
        }
        if (this.threadFactory != null && !this.dependencyResolver.canReuseDependency(this.threadFactory, threadFactoryJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.tickDuration, other.tickDuration)) {
            return false;
        }
        return Objects.deepEquals(this.ticksPerWheel, other.ticksPerWheel);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractHashedWheelTimerModule that = (AbstractHashedWheelTimerModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public ObjectName getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    @RequireInterface(value=ThreadFactoryServiceInterface.class)
    public void setThreadFactory(ObjectName threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Override
    public Long getTickDuration() {
        return this.tickDuration;
    }

    @Override
    public void setTickDuration(Long tickDuration) {
        this.tickDuration = tickDuration;
    }

    @Override
    public Integer getTicksPerWheel() {
        return this.ticksPerWheel;
    }

    @Override
    public void setTicksPerWheel(Integer ticksPerWheel) {
        this.ticksPerWheel = ticksPerWheel;
    }

    public Logger getLogger() {
        return LOG;
    }
}

