/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.NettyHashedWheelTimer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.timer.rev131119.modules.module.configuration.netty.hashed.wheel.timer.ThreadFactory;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NettyHashedWheelTimerBuilder
implements Builder<NettyHashedWheelTimer> {
    private ThreadFactory _threadFactory;
    private Long _tickDuration;
    private Integer _ticksPerWheel;
    Map<Class<? extends Augmentation<NettyHashedWheelTimer>>, Augmentation<NettyHashedWheelTimer>> augmentation = Collections.emptyMap();

    public NettyHashedWheelTimerBuilder() {
    }

    public NettyHashedWheelTimerBuilder(NettyHashedWheelTimer base) {
        AugmentationHolder casted;
        this._threadFactory = base.getThreadFactory();
        this._tickDuration = base.getTickDuration();
        this._ticksPerWheel = base.getTicksPerWheel();
        if (base instanceof NettyHashedWheelTimerImpl) {
            NettyHashedWheelTimerImpl impl = (NettyHashedWheelTimerImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NettyHashedWheelTimer>>, Augmentation<NettyHashedWheelTimer>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NettyHashedWheelTimer>>, Augmentation<NettyHashedWheelTimer>>(casted.augmentations());
        }
    }

    public ThreadFactory getThreadFactory() {
        return this._threadFactory;
    }

    public Long getTickDuration() {
        return this._tickDuration;
    }

    public Integer getTicksPerWheel() {
        return this._ticksPerWheel;
    }

    public <E extends Augmentation<NettyHashedWheelTimer>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NettyHashedWheelTimerBuilder setThreadFactory(ThreadFactory value) {
        this._threadFactory = value;
        return this;
    }

    private static void checkTickDurationRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public NettyHashedWheelTimerBuilder setTickDuration(Long value) {
        if (value != null) {
            NettyHashedWheelTimerBuilder.checkTickDurationRange(value);
        }
        this._tickDuration = value;
        return this;
    }

    private static void checkTicksPerWheelRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NettyHashedWheelTimerBuilder setTicksPerWheel(Integer value) {
        if (value != null) {
            NettyHashedWheelTimerBuilder.checkTicksPerWheelRange(value);
        }
        this._ticksPerWheel = value;
        return this;
    }

    public NettyHashedWheelTimerBuilder addAugmentation(Class<? extends Augmentation<NettyHashedWheelTimer>> augmentationType, Augmentation<NettyHashedWheelTimer> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NettyHashedWheelTimer>>, Augmentation<NettyHashedWheelTimer>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NettyHashedWheelTimerBuilder removeAugmentation(Class<? extends Augmentation<NettyHashedWheelTimer>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NettyHashedWheelTimer build() {
        return new NettyHashedWheelTimerImpl(this);
    }

    private static final class NettyHashedWheelTimerImpl
    implements NettyHashedWheelTimer {
        private final ThreadFactory _threadFactory;
        private final Long _tickDuration;
        private final Integer _ticksPerWheel;
        private Map<Class<? extends Augmentation<NettyHashedWheelTimer>>, Augmentation<NettyHashedWheelTimer>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NettyHashedWheelTimer> getImplementedInterface() {
            return NettyHashedWheelTimer.class;
        }

        private NettyHashedWheelTimerImpl(NettyHashedWheelTimerBuilder base) {
            this._threadFactory = base.getThreadFactory();
            this._tickDuration = base.getTickDuration();
            this._ticksPerWheel = base.getTicksPerWheel();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NettyHashedWheelTimer>>, Augmentation<NettyHashedWheelTimer>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NettyHashedWheelTimer>>, Augmentation<NettyHashedWheelTimer>>(base.augmentation);
                }
            }
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this._threadFactory;
        }

        @Override
        public Long getTickDuration() {
            return this._tickDuration;
        }

        @Override
        public Integer getTicksPerWheel() {
            return this._ticksPerWheel;
        }

        public <E extends Augmentation<NettyHashedWheelTimer>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._threadFactory);
            result = 31 * result + Objects.hashCode(this._tickDuration);
            result = 31 * result + Objects.hashCode(this._ticksPerWheel);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NettyHashedWheelTimer.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NettyHashedWheelTimer other = (NettyHashedWheelTimer)obj;
            if (!Objects.equals(this._threadFactory, other.getThreadFactory())) {
                return false;
            }
            if (!Objects.equals(this._tickDuration, other.getTickDuration())) {
                return false;
            }
            if (!Objects.equals(this._ticksPerWheel, other.getTicksPerWheel())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NettyHashedWheelTimerImpl otherImpl = (NettyHashedWheelTimerImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NettyHashedWheelTimer>>, Augmentation<NettyHashedWheelTimer>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "NettyHashedWheelTimer [";
            StringBuilder builder = new StringBuilder(name);
            if (this._threadFactory != null) {
                builder.append("_threadFactory=");
                builder.append(this._threadFactory);
                builder.append(", ");
            }
            if (this._tickDuration != null) {
                builder.append("_tickDuration=");
                builder.append(this._tickDuration);
                builder.append(", ");
            }
            if (this._ticksPerWheel != null) {
                builder.append("_ticksPerWheel=");
                builder.append(this._ticksPerWheel);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

