/*
 * Decompiled with CFR 0.152.
 */
package ntfbenchmark.impl;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.ExecutionException;
import ntfbenchmark.impl.AbstractNtfbenchProducer;
import org.opendaylight.controller.md.sal.binding.api.NotificationPublishService;
import org.opendaylight.yangtools.yang.binding.Notification;

public class NtfbenchNonblockingProducer
extends AbstractNtfbenchProducer {
    private final SettableFuture<?> lastDeliveryFuture = SettableFuture.create();

    public NtfbenchNonblockingProducer(NotificationPublishService publishService, int iterations, int payloadSize) {
        super(publishService, iterations, payloadSize);
    }

    @Override
    public void run() {
        int ntfOk = 0;
        int ntfError = 0;
        ListenableFuture lastOkFuture = null;
        for (int i = 0; i < this.iterations; ++i) {
            try {
                ListenableFuture result = this.publishService.offerNotification((Notification)this.ntf);
                if (NotificationPublishService.REJECTED == result) {
                    ++ntfError;
                    continue;
                }
                ++ntfOk;
                lastOkFuture = result;
                continue;
            }
            catch (Exception e) {
                ++ntfError;
            }
        }
        this.ntfOk = ntfOk;
        this.ntfError = ntfError;
        if (lastOkFuture != null) {
            try {
                lastOkFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

