/*
 * Decompiled with CFR 0.152.
 */
package ntfbenchmark.impl;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import ntfbenchmark.impl.AbstractNtfbenchProducer;
import ntfbenchmark.impl.NtfbenchBlockingProducer;
import ntfbenchmark.impl.NtfbenchTestListener;
import ntfbenchmark.impl.NtfbenchWTCListener;
import org.opendaylight.controller.md.sal.binding.api.NotificationPublishService;
import org.opendaylight.controller.md.sal.binding.api.NotificationService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.NtfbenchmarkService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.TestStatusOutput;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtfbenchmarkProvider
implements AutoCloseable,
NtfbenchmarkService {
    private static final Logger LOG = LoggerFactory.getLogger(NtfbenchmarkProvider.class);
    private final NotificationService listenService;
    private final NotificationPublishService publishService;
    private static final int testTimeout = 5;

    public NtfbenchmarkProvider(NotificationService listenServiceDependency, NotificationPublishService publishServiceDependency) {
        LOG.debug("NtfbenchmarkProvider Constructor");
        this.listenService = listenServiceDependency;
        this.publishService = publishServiceDependency;
    }

    public void init() {
        LOG.info("NtfbenchmarkProvider initiated");
    }

    @Override
    public void close() throws Exception {
        LOG.info("NtfbenchmarkProvider closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<RpcResult<StartTestOutput>> startTest(StartTestInput input) {
        int producerCount = input.getProducers().intValue();
        int listenerCount = input.getListeners().intValue();
        int iterations = input.getIterations().intValue();
        int payloadSize = input.getIterations().intValue();
        ArrayList<NtfbenchBlockingProducer> producers = new ArrayList<NtfbenchBlockingProducer>(producerCount);
        ArrayList<ListenerRegistration> listeners = new ArrayList<ListenerRegistration>(listenerCount);
        for (int i = 0; i < producerCount; ++i) {
            producers.add(new NtfbenchBlockingProducer(this.publishService, iterations, payloadSize));
        }
        int expectedCntPerListener = producerCount * iterations;
        for (int i = 0; i < listenerCount; ++i) {
            NtfbenchTestListener listener = input.getProducerType() == StartTestInput.ProducerType.BLOCKING ? new NtfbenchWTCListener(payloadSize, expectedCntPerListener) : new NtfbenchTestListener(payloadSize);
            listeners.add(this.listenService.registerNotificationListener((NotificationListener)listener));
        }
        try {
            ExecutorService executor = Executors.newFixedThreadPool(input.getProducers().intValue());
            LOG.info("Test Started");
            long startTime = System.nanoTime();
            for (int i = 0; i < input.getProducers().intValue(); ++i) {
                executor.submit((Runnable)producers.get(i));
            }
            executor.shutdown();
            try {
                executor.awaitTermination(5L, TimeUnit.MINUTES);
                for (ListenerRegistration listenerRegistration : listeners) {
                    ((NtfbenchTestListener)listenerRegistration.getInstance()).getAllDone().get();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Out of time: test did not finish within the {} min deadline ", (Object)5);
            }
            long producerEndTime = System.nanoTime();
            long producerElapsedTime = producerEndTime - startTime;
            long allListeners = 0L;
            long allProducersOk = 0L;
            long allProducersError = 0L;
            for (ListenerRegistration listenerRegistration : listeners) {
                allListeners += (long)((NtfbenchTestListener)listenerRegistration.getInstance()).getReceived();
            }
            long listenerEndTime = System.nanoTime();
            long listenerElapsedTime = producerEndTime - startTime;
            LOG.info("Test Done");
            for (AbstractNtfbenchProducer listenableFuture : producers) {
                allProducersOk += (long)listenableFuture.getNtfOk();
                allProducersError += (long)listenableFuture.getNtfError();
            }
            StartTestOutput output = new StartTestOutputBuilder().setProducerElapsedTime(Long.valueOf(producerElapsedTime / 1000000L)).setListenerElapsedTime(Long.valueOf(listenerElapsedTime / 1000000L)).setListenerOk(Long.valueOf(allListeners)).setProducerOk(Long.valueOf(allProducersOk)).setProducerError(Long.valueOf(allProducersError)).setProducerRate(Long.valueOf((allProducersOk + allProducersError) * 1000000000L / producerElapsedTime)).setListenerRate(Long.valueOf(allListeners * 1000000000L / listenerElapsedTime)).build();
            ListenableFuture listenableFuture = RpcResultBuilder.success((Object)output).buildFuture();
            return listenableFuture;
        }
        finally {
            for (ListenerRegistration listenerRegistration : listeners) {
                listenerRegistration.close();
            }
        }
    }

    public Future<RpcResult<TestStatusOutput>> testStatus() {
        return null;
    }
}

