/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.akka.segjournal;

import com.codahale.metrics.Histogram;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

abstract class DataJournal {
    final @NonNull String persistenceId;
    private final Histogram messageSize;
    private int largestObservedSize;

    DataJournal(String persistenceId, Histogram messageSize) {
        this.persistenceId = Objects.requireNonNull(persistenceId);
        this.messageSize = Objects.requireNonNull(messageSize);
    }

    final void recordMessageSize(int size) {
        this.messageSize.update(size);
        this.updateLargestSize(size);
    }

    final void updateLargestSize(int size) {
        if (size > this.largestObservedSize) {
            this.largestObservedSize = size;
        }
    }

    abstract long lastWrittenSequenceNr();

    abstract void deleteTo(long var1);

    abstract void compactTo(long var1);

    abstract void close();

    abstract void handleReplayMessages( @NonNull SegmentedJournalActor.ReplayMessages var1, long var2);

    abstract void handleWriteMessages( @NonNull SegmentedJournalActor.WriteMessages var1);
}

