/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.akka.segjournal;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.persistence.PersistentRepr;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.google.common.base.Verify;
import java.util.Objects;
import org.opendaylight.controller.akka.segjournal.DataJournalEntry;

final class DataJournalEntrySerializer
extends Serializer<DataJournalEntry> {
    private final JavaSerializer serializer = new JavaSerializer();
    private final ExtendedActorSystem actorSystem;

    DataJournalEntrySerializer(ActorSystem actorSystem) {
        this.actorSystem = Objects.requireNonNull((ExtendedActorSystem)actorSystem);
    }

    @Override
    public void write(Kryo kryo, Output output, DataJournalEntry object) {
        Verify.verify((boolean)(object instanceof DataJournalEntry.ToPersistence));
        PersistentRepr repr = ((DataJournalEntry.ToPersistence)object).repr();
        output.writeString(repr.manifest());
        output.writeString(repr.writerUuid());
        this.serializer.write(kryo, output, repr.payload());
    }

    @Override
    public DataJournalEntry read(Kryo kryo, Input input, Class<DataJournalEntry> type) {
        String manifest = input.readString();
        String uuid = input.readString();
        Object payload = akka.serialization.JavaSerializer.currentSystem().withValue(this.actorSystem, () -> this.serializer.read(kryo, input, (Class)type));
        return new DataJournalEntry.FromPersistence(manifest, uuid, payload);
    }
}

