/*
 * Copyright (c) 2014 Cisco Systems, Inc. and others.  All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 */
package org.opendaylight.controller.md.sal.binding.api;

import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeEvent;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeListener;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

/*
 * DataChangeListener enables data change notifications only at leader of the datastore shard
 *
 * @Deprecated Replaced by {@link DataTreeChangeListener}
 */
@Deprecated
public interface DataChangeListener extends AsyncDataChangeListener<InstanceIdentifier<?>, DataObject> {
    @Override
    void onDataChanged(AsyncDataChangeEvent<InstanceIdentifier<?>, DataObject> change);
}
