/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.api.rpc;

import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.binding.RpcService;

public final class RpcContextIdentifier
implements Immutable {
    public final Class<? extends RpcService> rpcService;
    public final Class<? extends BaseIdentity> routingContext;

    private RpcContextIdentifier(Class<? extends RpcService> rpcService, Class<? extends BaseIdentity> routingContext) {
        this.rpcService = rpcService;
        this.routingContext = routingContext;
    }

    public Class<? extends RpcService> getRpcService() {
        return this.rpcService;
    }

    public Class<? extends BaseIdentity> getRoutingContext() {
        return this.routingContext;
    }

    public static final RpcContextIdentifier contextForGlobalRpc(Class<? extends RpcService> serviceType) {
        return new RpcContextIdentifier(serviceType, null);
    }

    public static final RpcContextIdentifier contextFor(Class<? extends RpcService> serviceType, Class<? extends BaseIdentity> routingContext) {
        return new RpcContextIdentifier(serviceType, routingContext);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.routingContext == null ? 0 : this.routingContext.hashCode());
        result = 31 * result + (this.rpcService == null ? 0 : this.rpcService.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RpcContextIdentifier other = (RpcContextIdentifier)obj;
        if (this.routingContext == null ? other.routingContext != null : !this.routingContext.equals(other.routingContext)) {
            return false;
        }
        return !(this.rpcService == null ? other.rpcService != null : !this.rpcService.equals(other.rpcService));
    }
}

