/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl.test;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import org.junit.Test;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.binding.test.AbstractDataTreeChangeListenerTest;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.test.model.util.ListsBindingUtils;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.TreeComplexUsesAugment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.TreeLeafOnlyUsesAugment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.complex.from.grouping.ListViaUsesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.Top;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;

@Deprecated
public class Bug1418AugmentationTest
extends AbstractDataTreeChangeListenerTest {
    private static final InstanceIdentifier<Top> TOP = InstanceIdentifier.create(Top.class);
    private static final InstanceIdentifier<TopLevelList> TOP_FOO = TOP.child(TopLevelList.class, (Identifier)ListsBindingUtils.TOP_FOO_KEY);
    private static final InstanceIdentifier<TreeLeafOnlyUsesAugment> SIMPLE_AUGMENT = TOP.child(TopLevelList.class, (Identifier)ListsBindingUtils.TOP_FOO_KEY).augmentation(TreeLeafOnlyUsesAugment.class);
    private static final InstanceIdentifier<TreeComplexUsesAugment> COMPLEX_AUGMENT = TOP.child(TopLevelList.class, (Identifier)ListsBindingUtils.TOP_FOO_KEY).augmentation(TreeComplexUsesAugment.class);
    private static final ListViaUsesKey LIST_VIA_USES_KEY = new ListViaUsesKey("list key");
    private static final ListViaUsesKey LIST_VIA_USES_KEY_MOD = new ListViaUsesKey("list key modified");

    @Override
    protected Set<YangModuleInfo> getModuleInfos() throws Exception {
        return ImmutableSet.of((Object)BindingReflections.getModuleInfo(Top.class), (Object)BindingReflections.getModuleInfo(TreeComplexUsesAugment.class), (Object)BindingReflections.getModuleInfo(TreeLeafOnlyUsesAugment.class));
    }

    @Test
    public void leafOnlyAugmentationCreatedTest() {
        TreeLeafOnlyUsesAugment leafOnlyUsesAugment = ListsBindingUtils.leafOnlyUsesAugment((String)"test leaf");
        AbstractDataTreeChangeListenerTest.TestListener<TreeLeafOnlyUsesAugment> listener = this.createListener(LogicalDatastoreType.CONFIGURATION, SIMPLE_AUGMENT, Bug1418AugmentationTest.added(ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, TreeLeafOnlyUsesAugment.class), leafOnlyUsesAugment));
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP, (DataObject)ListsBindingUtils.top((TopLevelList[])new TopLevelList[0]));
        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP_FOO, (DataObject)ListsBindingUtils.topLevelList((TopLevelListKey)new TopLevelListKey(ListsBindingUtils.TOP_FOO_KEY)));
        writeTx.put(LogicalDatastoreType.CONFIGURATION, SIMPLE_AUGMENT, (DataObject)leafOnlyUsesAugment);
        Bug1418AugmentationTest.assertCommit((ListenableFuture<Void>)writeTx.submit());
        listener.verify();
    }

    @Test
    public void leafOnlyAugmentationUpdatedTest() {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP, (DataObject)ListsBindingUtils.top((TopLevelList[])new TopLevelList[0]));
        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP_FOO, (DataObject)ListsBindingUtils.topLevelList((TopLevelListKey)new TopLevelListKey(ListsBindingUtils.TOP_FOO_KEY)));
        TreeLeafOnlyUsesAugment leafOnlyUsesAugmentBefore = ListsBindingUtils.leafOnlyUsesAugment((String)"test leaf");
        writeTx.put(LogicalDatastoreType.CONFIGURATION, SIMPLE_AUGMENT, (DataObject)leafOnlyUsesAugmentBefore);
        Bug1418AugmentationTest.assertCommit((ListenableFuture<Void>)writeTx.submit());
        TreeLeafOnlyUsesAugment leafOnlyUsesAugmentAfter = ListsBindingUtils.leafOnlyUsesAugment((String)"test leaf changed");
        AbstractDataTreeChangeListenerTest.TestListener<TreeLeafOnlyUsesAugment> listener = this.createListener(LogicalDatastoreType.CONFIGURATION, SIMPLE_AUGMENT, Bug1418AugmentationTest.added(ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, TreeLeafOnlyUsesAugment.class), leafOnlyUsesAugmentBefore), Bug1418AugmentationTest.replaced(ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, TreeLeafOnlyUsesAugment.class), leafOnlyUsesAugmentBefore, leafOnlyUsesAugmentAfter));
        writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.CONFIGURATION, SIMPLE_AUGMENT, (DataObject)leafOnlyUsesAugmentAfter);
        Bug1418AugmentationTest.assertCommit((ListenableFuture<Void>)writeTx.submit());
        listener.verify();
    }

    @Test
    public void leafOnlyAugmentationDeletedTest() {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP, (DataObject)ListsBindingUtils.top((TopLevelList[])new TopLevelList[0]));
        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP_FOO, (DataObject)ListsBindingUtils.topLevelList((TopLevelListKey)new TopLevelListKey(ListsBindingUtils.TOP_FOO_KEY)));
        TreeLeafOnlyUsesAugment leafOnlyUsesAugment = ListsBindingUtils.leafOnlyUsesAugment((String)"test leaf");
        writeTx.put(LogicalDatastoreType.CONFIGURATION, SIMPLE_AUGMENT, (DataObject)leafOnlyUsesAugment);
        Bug1418AugmentationTest.assertCommit((ListenableFuture<Void>)writeTx.submit());
        AbstractDataTreeChangeListenerTest.TestListener<TreeLeafOnlyUsesAugment> listener = this.createListener(LogicalDatastoreType.CONFIGURATION, SIMPLE_AUGMENT, Bug1418AugmentationTest.added(ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, TreeLeafOnlyUsesAugment.class), leafOnlyUsesAugment), Bug1418AugmentationTest.deleted(ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, TreeLeafOnlyUsesAugment.class), leafOnlyUsesAugment));
        writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.delete(LogicalDatastoreType.CONFIGURATION, SIMPLE_AUGMENT);
        Bug1418AugmentationTest.assertCommit((ListenableFuture<Void>)writeTx.submit());
        listener.verify();
    }

    @Test
    public void complexAugmentationCreatedTest() {
        TreeComplexUsesAugment complexUsesAugment = ListsBindingUtils.complexUsesAugment((ListViaUsesKey[])new ListViaUsesKey[]{LIST_VIA_USES_KEY});
        AbstractDataTreeChangeListenerTest.TestListener<TreeComplexUsesAugment> listener = this.createListener(LogicalDatastoreType.CONFIGURATION, COMPLEX_AUGMENT, Bug1418AugmentationTest.added(ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, TreeComplexUsesAugment.class), complexUsesAugment));
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP, (DataObject)ListsBindingUtils.top((TopLevelList[])new TopLevelList[0]));
        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP_FOO, (DataObject)ListsBindingUtils.topLevelList((TopLevelListKey)new TopLevelListKey(ListsBindingUtils.TOP_FOO_KEY)));
        writeTx.put(LogicalDatastoreType.CONFIGURATION, COMPLEX_AUGMENT, (DataObject)complexUsesAugment);
        Bug1418AugmentationTest.assertCommit((ListenableFuture<Void>)writeTx.submit());
        listener.verify();
    }

    @Test
    public void complexAugmentationUpdatedTest() {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP, (DataObject)ListsBindingUtils.top((TopLevelList[])new TopLevelList[0]));
        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP_FOO, (DataObject)ListsBindingUtils.topLevelList((TopLevelListKey)new TopLevelListKey(ListsBindingUtils.TOP_FOO_KEY)));
        TreeComplexUsesAugment complexUsesAugmentBefore = ListsBindingUtils.complexUsesAugment((ListViaUsesKey[])new ListViaUsesKey[]{LIST_VIA_USES_KEY});
        writeTx.put(LogicalDatastoreType.CONFIGURATION, COMPLEX_AUGMENT, (DataObject)complexUsesAugmentBefore);
        Bug1418AugmentationTest.assertCommit((ListenableFuture<Void>)writeTx.submit());
        TreeComplexUsesAugment complexUsesAugmentAfter = ListsBindingUtils.complexUsesAugment((ListViaUsesKey[])new ListViaUsesKey[]{LIST_VIA_USES_KEY_MOD});
        AbstractDataTreeChangeListenerTest.TestListener<TreeComplexUsesAugment> listener = this.createListener(LogicalDatastoreType.CONFIGURATION, COMPLEX_AUGMENT, Bug1418AugmentationTest.added(ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, TreeComplexUsesAugment.class), complexUsesAugmentBefore), Bug1418AugmentationTest.replaced(ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, TreeComplexUsesAugment.class), complexUsesAugmentBefore, complexUsesAugmentAfter));
        writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.CONFIGURATION, COMPLEX_AUGMENT, (DataObject)complexUsesAugmentAfter);
        Bug1418AugmentationTest.assertCommit((ListenableFuture<Void>)writeTx.submit());
        listener.verify();
    }
}

