/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl.test;

import com.google.common.base.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.binding.test.AbstractConcurrentDataBrokerTest;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.Top;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.TopBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

@Deprecated
public class WriteTransactionTest
extends AbstractConcurrentDataBrokerTest {
    private static final InstanceIdentifier<Top> TOP_PATH = InstanceIdentifier.create(Top.class);
    private static final TopLevelListKey TOP_LIST_KEY = new TopLevelListKey("foo");
    private static final InstanceIdentifier<TopLevelList> NODE_PATH = TOP_PATH.child(TopLevelList.class, (Identifier)TOP_LIST_KEY);
    private static final TopLevelList NODE = new TopLevelListBuilder().withKey(TOP_LIST_KEY).build();

    @Test
    @Deprecated
    public void testSubmit() throws InterruptedException, ExecutionException, TimeoutException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, TOP_PATH, (DataObject)new TopBuilder().build());
        writeTx.put(LogicalDatastoreType.OPERATIONAL, NODE_PATH, (DataObject)NODE);
        writeTx.submit().get(5L, TimeUnit.SECONDS);
        ReadOnlyTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional listNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, NODE_PATH).get();
        Assert.assertTrue((String)"List node must exists after commit", (boolean)listNode.isPresent());
        Assert.assertEquals((String)"List node", (Object)NODE, (Object)listNode.get());
    }

    @Test
    public void testCommit() throws InterruptedException, ExecutionException, TimeoutException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, TOP_PATH, (DataObject)new TopBuilder().build());
        writeTx.put(LogicalDatastoreType.OPERATIONAL, NODE_PATH, (DataObject)NODE);
        writeTx.commit().get(5L, TimeUnit.SECONDS);
        ReadOnlyTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional listNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, NODE_PATH).get();
        Assert.assertTrue((String)"List node must exists after commit", (boolean)listNode.isPresent());
        Assert.assertEquals((String)"List node", (Object)NODE, (Object)listNode.get());
    }

    @Test
    public void testPutCreateParentsSuccess() throws InterruptedException, ExecutionException, TimeoutException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, NODE_PATH, (DataObject)NODE, true);
        writeTx.commit().get(5L, TimeUnit.SECONDS);
        ReadOnlyTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional topNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, TOP_PATH).get();
        Assert.assertTrue((String)"Top node must exists after commit", (boolean)topNode.isPresent());
        Optional listNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, NODE_PATH).get();
        Assert.assertTrue((String)"List node must exists after commit", (boolean)listNode.isPresent());
    }

    @Test
    public void testMergeCreateParentsSuccess() throws InterruptedException, ExecutionException, TimeoutException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.merge(LogicalDatastoreType.OPERATIONAL, NODE_PATH, (DataObject)NODE, true);
        writeTx.commit().get(5L, TimeUnit.SECONDS);
        ReadOnlyTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional topNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, TOP_PATH).get();
        Assert.assertTrue((String)"Top node must exists after commit", (boolean)topNode.isPresent());
        Optional listNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, NODE_PATH).get();
        Assert.assertTrue((String)"List node must exists after commit", (boolean)listNode.isPresent());
    }
}

