/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.test;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutorService;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.NotificationPublishService;
import org.opendaylight.controller.md.sal.binding.api.NotificationService;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMDataBrokerAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMNotificationPublishServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMNotificationServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationPublishService;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationService;
import org.opendaylight.controller.md.sal.dom.broker.impl.DOMNotificationRouter;
import org.opendaylight.controller.md.sal.dom.broker.impl.SerializedDOMDataBroker;
import org.opendaylight.controller.md.sal.dom.store.impl.InMemoryDOMDataStore;
import org.opendaylight.controller.sal.binding.test.util.MockSchemaService;
import org.opendaylight.controller.sal.core.spi.data.DOMStore;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingNormalizedNodeCodecRegistry;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.impl.GeneratedClassLoadingStrategy;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;

@Deprecated
public abstract class AbstractDataBrokerTestCustomizer {
    private DOMDataBroker domDataBroker;
    private final DOMNotificationRouter domNotificationRouter;
    private final MockSchemaService schemaService = new MockSchemaService();
    private ImmutableMap<LogicalDatastoreType, DOMStore> datastores;
    private final BindingToNormalizedNodeCodec bindingToNormalized;

    public ImmutableMap<LogicalDatastoreType, DOMStore> createDatastores() {
        return ImmutableMap.builder().put((Object)LogicalDatastoreType.OPERATIONAL, (Object)this.createOperationalDatastore()).put((Object)LogicalDatastoreType.CONFIGURATION, (Object)this.createConfigurationDatastore()).build();
    }

    public AbstractDataBrokerTestCustomizer() {
        BindingNormalizedNodeCodecRegistry codecRegistry = new BindingNormalizedNodeCodecRegistry();
        GeneratedClassLoadingStrategy loading = GeneratedClassLoadingStrategy.getTCCLClassLoadingStrategy();
        this.bindingToNormalized = new BindingToNormalizedNodeCodec((ClassLoadingStrategy)loading, codecRegistry);
        this.schemaService.registerSchemaContextListener((SchemaContextListener)this.bindingToNormalized);
        this.domNotificationRouter = DOMNotificationRouter.create((int)16);
    }

    public DOMStore createConfigurationDatastore() {
        InMemoryDOMDataStore store = new InMemoryDOMDataStore("CFG", (ExecutorService)this.getDataTreeChangeListenerExecutor());
        this.schemaService.registerSchemaContextListener((SchemaContextListener)store);
        return store;
    }

    public DOMStore createOperationalDatastore() {
        InMemoryDOMDataStore store = new InMemoryDOMDataStore("OPER", (ExecutorService)this.getDataTreeChangeListenerExecutor());
        this.schemaService.registerSchemaContextListener((SchemaContextListener)store);
        return store;
    }

    public DOMDataBroker createDOMDataBroker() {
        return new SerializedDOMDataBroker(this.getDatastores(), this.getCommitCoordinatorExecutor());
    }

    public NotificationService createNotificationService() {
        return new BindingDOMNotificationServiceAdapter((BindingNormalizedNodeSerializer)this.bindingToNormalized.getCodecRegistry(), (DOMNotificationService)this.domNotificationRouter);
    }

    public NotificationPublishService createNotificationPublishService() {
        return new BindingDOMNotificationPublishServiceAdapter(this.bindingToNormalized, (DOMNotificationPublishService)this.domNotificationRouter);
    }

    public abstract ListeningExecutorService getCommitCoordinatorExecutor();

    public ListeningExecutorService getDataTreeChangeListenerExecutor() {
        return MoreExecutors.newDirectExecutorService();
    }

    public DataBroker createDataBroker() {
        return new BindingDOMDataBrokerAdapter(this.getDOMDataBroker(), this.bindingToNormalized);
    }

    public BindingToNormalizedNodeCodec getBindingToNormalized() {
        return this.bindingToNormalized;
    }

    public DOMSchemaService getSchemaService() {
        return this.schemaService;
    }

    public DOMDataBroker getDOMDataBroker() {
        if (this.domDataBroker == null) {
            this.domDataBroker = this.createDOMDataBroker();
        }
        return this.domDataBroker;
    }

    private synchronized ImmutableMap<LogicalDatastoreType, DOMStore> getDatastores() {
        if (this.datastores == null) {
            this.datastores = this.createDatastores();
        }
        return this.datastores;
    }

    public void updateSchema(SchemaContext ctx) {
        this.schemaService.changeSchema(ctx);
    }

    public DOMNotificationRouter getDomNotificationRouter() {
        return this.domNotificationRouter;
    }
}

