/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.test.tests;

import com.google.common.base.Optional;
import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.binding.test.AbstractConcurrentDataBrokerTest;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.md.sal.test.model.util.ListsBindingUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.TreeComplexUsesAugment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.TreeComplexUsesAugmentBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.complex.from.grouping.ContainerWithUsesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.Top;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.TopBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

@Deprecated
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class AbstractDataBrokerTestTest
extends AbstractConcurrentDataBrokerTest {
    private static final InstanceIdentifier<Top> TOP_PATH = InstanceIdentifier.create(Top.class);

    @Before
    public void before() {
        Truth.assertThat((Object)this.getDataBroker()).isNotNull();
    }

    @Test
    public void aEnsureDataBrokerIsNotNull() {
        Truth.assertThat((Object)this.getDataBroker()).isNotNull();
    }

    @Test
    public void bPutSomethingIntoDataStore() throws Exception {
        this.writeInitialState();
        Truth.assertThat((Boolean)this.isTopInDataStore()).isTrue();
    }

    @Test
    public void cEnsureDataStoreIsEmptyAgainInNewTest() throws ReadFailedException {
        Truth.assertThat((Boolean)this.isTopInDataStore()).isFalse();
    }

    private void writeInitialState() throws TransactionCommitFailedException {
        WriteTransaction initialTx = this.getDataBroker().newWriteOnlyTransaction();
        initialTx.put(LogicalDatastoreType.OPERATIONAL, TOP_PATH, (DataObject)new TopBuilder().build());
        TreeComplexUsesAugment fooAugment = new TreeComplexUsesAugmentBuilder().setContainerWithUses(new ContainerWithUsesBuilder().setLeafFromGrouping("foo").build()).build();
        initialTx.put(LogicalDatastoreType.OPERATIONAL, ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY), (DataObject)ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, (TreeComplexUsesAugment)fooAugment));
        initialTx.submit().checkedGet();
    }

    private boolean isTopInDataStore() throws ReadFailedException {
        try (ReadOnlyTransaction readTx = this.getDataBroker().newReadOnlyTransaction();){
            boolean bl = ((Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, TOP_PATH).checkedGet()).isPresent();
            return bl;
        }
    }
}

