/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl.test;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Test;
import org.opendaylight.controller.md.sal.binding.api.DataObjectModification;
import org.opendaylight.controller.md.sal.binding.api.ReadWriteTransaction;
import org.opendaylight.controller.md.sal.binding.test.AbstractDataTreeChangeListenerTest;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.Root;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.RootBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root.ListInRoot;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root.ListInRootBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;

@Deprecated
public class Bug3090MultiKeyList
extends AbstractDataTreeChangeListenerTest {
    private static final InstanceIdentifier<Root> ROOT_PATH = InstanceIdentifier.create(Root.class);

    @Override
    protected Set<YangModuleInfo> getModuleInfos() throws Exception {
        return ImmutableSet.of((Object)BindingReflections.getModuleInfo(Root.class));
    }

    @Test
    public void listWithMultiKeyTest() {
        ArrayList<ListInRoot> listInRoots = new ArrayList<ListInRoot>();
        for (int i = 0; i < 10; ++i) {
            listInRoots.add(new ListInRootBuilder().setLeafA("leaf a" + i).setLeafC("leaf c" + i).setLeafB("leaf b" + i).build());
        }
        Root root = new RootBuilder().setListInRoot(listInRoots).build();
        AbstractDataTreeChangeListenerTest.TestListener<Root> listener = this.createListener(LogicalDatastoreType.CONFIGURATION, ROOT_PATH, Bug3090MultiKeyList.match(DataObjectModification.ModificationType.WRITE, ROOT_PATH, Objects::isNull, dataAfter -> Bug3090MultiKeyList.checkData(root, dataAfter)));
        ReadWriteTransaction readWriteTransaction = this.getDataBroker().newReadWriteTransaction();
        readWriteTransaction.put(LogicalDatastoreType.CONFIGURATION, ROOT_PATH, (DataObject)root);
        Bug3090MultiKeyList.assertCommit((ListenableFuture<Void>)readWriteTransaction.submit());
        listener.verify();
    }

    private static boolean checkData(Root expected, Root actual) {
        if (actual == null) {
            return false;
        }
        HashSet expListInRoot = new HashSet(expected.getListInRoot());
        Set actualListInRoot = actual.getListInRoot().stream().map(list -> new ListInRootBuilder(list).build()).collect(Collectors.toSet());
        return expListInRoot.equals(actualListInRoot);
    }
}

