/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.test;

import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.junit.Assert;
import org.opendaylight.controller.md.sal.binding.api.DataObjectModification;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataTreeIdentifier;
import org.opendaylight.controller.md.sal.binding.api.DataTreeModification;
import org.opendaylight.controller.md.sal.binding.test.AbstractConcurrentDataBrokerTest;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

@Deprecated
public class AbstractDataTreeChangeListenerTest
extends AbstractConcurrentDataBrokerTest {
    protected AbstractDataTreeChangeListenerTest() {
        super(true);
    }

    @SafeVarargs
    protected final <T extends DataObject> TestListener<T> createListener(LogicalDatastoreType store, InstanceIdentifier<T> path, Function<DataTreeModification<T>, Boolean> ... matchers) {
        TestListener<T> listener = new TestListener<T>(matchers);
        this.getDataBroker().registerDataTreeChangeListener(new DataTreeIdentifier(store, path), listener);
        return listener;
    }

    public static <T extends DataObject> Function<DataTreeModification<T>, Boolean> match(DataObjectModification.ModificationType type, InstanceIdentifier<T> path, Function<T, Boolean> checkDataBefore, Function<T, Boolean> checkDataAfter) {
        return modification -> type == modification.getRootNode().getModificationType() && path.equals((Object)modification.getRootPath().getRootIdentifier()) && (Boolean)checkDataBefore.apply(modification.getRootNode().getDataBefore()) != false && (Boolean)checkDataAfter.apply(modification.getRootNode().getDataAfter()) != false;
    }

    public static <T extends DataObject> Function<DataTreeModification<T>, Boolean> match(DataObjectModification.ModificationType type, InstanceIdentifier<T> path, T expDataBefore, T expDataAfter) {
        return AbstractDataTreeChangeListenerTest.match(type, path, dataBefore -> Objects.equals(expDataBefore, dataBefore), dataAfter -> Objects.equals(expDataAfter, dataAfter));
    }

    public static <T extends DataObject> Function<DataTreeModification<T>, Boolean> added(InstanceIdentifier<T> path, T data) {
        return AbstractDataTreeChangeListenerTest.match(DataObjectModification.ModificationType.WRITE, path, null, data);
    }

    public static <T extends DataObject> Function<DataTreeModification<T>, Boolean> replaced(InstanceIdentifier<T> path, T dataBefore, T dataAfter) {
        return AbstractDataTreeChangeListenerTest.match(DataObjectModification.ModificationType.WRITE, path, dataBefore, dataAfter);
    }

    public static <T extends DataObject> Function<DataTreeModification<T>, Boolean> deleted(InstanceIdentifier<T> path, T dataBefore) {
        return AbstractDataTreeChangeListenerTest.match(DataObjectModification.ModificationType.DELETE, path, dataBefore, null);
    }

    public static <T extends DataObject> Function<DataTreeModification<T>, Boolean> subtreeModified(InstanceIdentifier<T> path, T dataBefore, T dataAfter) {
        return AbstractDataTreeChangeListenerTest.match(DataObjectModification.ModificationType.SUBTREE_MODIFIED, path, dataBefore, dataAfter);
    }

    protected static final class TestListener<T extends DataObject>
    implements DataTreeChangeListener<T> {
        private final List<DataTreeModification<T>> accumulatedChanges = new ArrayList<DataTreeModification<T>>();
        private final SettableFuture<Collection<DataTreeModification<T>>> future = SettableFuture.create();
        private final Function<DataTreeModification<T>, Boolean>[] matchers;
        private final int expChangeCount;

        private TestListener(Function<DataTreeModification<T>, Boolean>[] matchers) {
            this.expChangeCount = matchers.length;
            this.matchers = matchers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDataTreeChanged(Collection<DataTreeModification<T>> changes) {
            List<DataTreeModification<T>> list = this.accumulatedChanges;
            synchronized (list) {
                this.accumulatedChanges.addAll(changes);
                if (this.expChangeCount == this.accumulatedChanges.size()) {
                    this.future.set(new ArrayList<DataTreeModification<T>>(this.accumulatedChanges));
                }
            }
        }

        public Collection<DataTreeModification<T>> changes() {
            try {
                Collection changes = (Collection)this.future.get(5L, TimeUnit.SECONDS);
                Uninterruptibles.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                return changes;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new AssertionError(String.format("Data tree change notifications not received. Expected: %s. Actual: %s - %s", this.expChangeCount, this.accumulatedChanges.size(), this.accumulatedChanges), e);
            }
        }

        public void verify() {
            ArrayList<DataTreeModification<T>> changes = new ArrayList<DataTreeModification<T>>(this.changes());
            Iterator iter = changes.iterator();
            block0: while (iter.hasNext()) {
                DataTreeModification dataTreeModification = (DataTreeModification)iter.next();
                for (Function<DataTreeModification<DataTreeModification>, Boolean> function : this.matchers) {
                    if (!function.apply(dataTreeModification).booleanValue()) continue;
                    iter.remove();
                    continue block0;
                }
            }
            if (!changes.isEmpty()) {
                DataTreeModification mod = (DataTreeModification)changes.iterator().next();
                Assert.fail((String)String.format("Received unexpected notification: type: %s, path: %s, before: %s, after: %s", mod.getRootNode().getModificationType(), mod.getRootPath().getRootIdentifier(), mod.getRootNode().getDataBefore(), mod.getRootNode().getDataAfter()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasChanges() {
            List<DataTreeModification<T>> list = this.accumulatedChanges;
            synchronized (list) {
                return !this.accumulatedChanges.isEmpty();
            }
        }
    }
}

