/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.test.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.MountPointService;
import org.opendaylight.controller.md.sal.binding.api.NotificationPublishService;
import org.opendaylight.controller.md.sal.binding.api.NotificationService;
import org.opendaylight.controller.md.sal.binding.compat.HeliumNotificationProviderServiceAdapter;
import org.opendaylight.controller.md.sal.binding.compat.HeliumRpcProviderRegistry;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMDataBrokerAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMMountPointServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMNotificationPublishServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMNotificationServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMRpcProviderServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMRpcServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPointService;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationPublishService;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationService;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcProviderService;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcService;
import org.opendaylight.controller.md.sal.dom.broker.impl.DOMNotificationRouter;
import org.opendaylight.controller.md.sal.dom.broker.impl.SerializedDOMDataBroker;
import org.opendaylight.controller.md.sal.dom.broker.impl.mount.DOMMountPointServiceImpl;
import org.opendaylight.controller.md.sal.dom.store.impl.InMemoryDOMDataStore;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.binding.api.RpcConsumerRegistry;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.controller.sal.binding.impl.RootBindingAwareBroker;
import org.opendaylight.controller.sal.binding.test.util.MockSchemaService;
import org.opendaylight.controller.sal.core.spi.data.DOMStore;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingNormalizedNodeCodecRegistry;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.impl.GeneratedClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.impl.ModuleInfoBackedContext;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.broker.DOMRpcRouter;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;

@Deprecated
@Beta
public class BindingTestContext
implements AutoCloseable {
    private BindingToNormalizedNodeCodec codec;
    private RootBindingAwareBroker baBrokerImpl;
    private HeliumNotificationProviderServiceAdapter baNotifyImpl;
    private final ListeningExecutorService executor;
    private final boolean startWithSchema;
    private DOMMountPointService biMountImpl;
    private ImmutableMap<LogicalDatastoreType, DOMStore> newDatastores;
    private DOMDataBroker newDOMDataBroker;
    private final MockSchemaService mockSchemaService = new MockSchemaService();
    private DataBroker dataBroker;
    private RpcConsumerRegistry baConsumerRpc;
    private BindingDOMRpcProviderServiceAdapter baProviderRpc;
    private org.opendaylight.controller.md.sal.dom.broker.impl.DOMRpcRouter domRouter;
    private DOMRpcRouter delegateDomRouter;
    private NotificationPublishService publishService;
    private NotificationService listenService;
    private DOMNotificationPublishService domPublishService;
    private DOMNotificationService domListenService;
    private Set<YangModuleInfo> schemaModuleInfos;

    public DOMDataBroker getDomAsyncDataBroker() {
        return this.newDOMDataBroker;
    }

    public BindingToNormalizedNodeCodec getCodec() {
        return this.codec;
    }

    protected BindingTestContext(ListeningExecutorService executor, boolean startWithSchema) {
        this.executor = executor;
        this.startWithSchema = startWithSchema;
    }

    public void startDomDataBroker() {
    }

    public void startNewDataBroker() {
        Preconditions.checkState((this.executor != null ? 1 : 0) != 0, (Object)"Executor needs to be set");
        Preconditions.checkState((this.newDOMDataBroker != null ? 1 : 0) != 0, (Object)"DOM Data Broker must be set");
        this.dataBroker = new BindingDOMDataBrokerAdapter(this.newDOMDataBroker, this.codec);
    }

    public void startNewDomDataBroker() {
        Preconditions.checkState((this.executor != null ? 1 : 0) != 0, (Object)"Executor needs to be set");
        InMemoryDOMDataStore operStore = new InMemoryDOMDataStore("OPER", (ExecutorService)MoreExecutors.newDirectExecutorService());
        InMemoryDOMDataStore configStore = new InMemoryDOMDataStore("CFG", (ExecutorService)MoreExecutors.newDirectExecutorService());
        this.newDatastores = ImmutableMap.builder().put((Object)LogicalDatastoreType.OPERATIONAL, (Object)operStore).put((Object)LogicalDatastoreType.CONFIGURATION, (Object)configStore).build();
        this.newDOMDataBroker = new SerializedDOMDataBroker(this.newDatastores, this.executor);
        this.mockSchemaService.registerSchemaContextListener((SchemaContextListener)configStore);
        this.mockSchemaService.registerSchemaContextListener((SchemaContextListener)operStore);
    }

    public void startBindingDataBroker() {
    }

    public void startBindingBroker() {
        Preconditions.checkState((this.executor != null ? 1 : 0) != 0, (Object)"Executor needs to be set");
        Preconditions.checkState((this.baNotifyImpl != null ? 1 : 0) != 0, (Object)"Notification Service must be started");
        this.baConsumerRpc = new BindingDOMRpcServiceAdapter(this.getDomRpcInvoker(), this.codec);
        this.baProviderRpc = new BindingDOMRpcProviderServiceAdapter(this.getDomRpcRegistry(), this.codec);
        this.baBrokerImpl = new RootBindingAwareBroker("test");
        BindingDOMMountPointServiceAdapter mountService = new BindingDOMMountPointServiceAdapter(this.biMountImpl, this.codec);
        this.baBrokerImpl.setMountService((MountPointService)mountService);
        this.baBrokerImpl.setRpcBroker((RpcProviderRegistry)new HeliumRpcProviderRegistry(this.baConsumerRpc, this.baProviderRpc));
        this.baBrokerImpl.setNotificationBroker((NotificationProviderService)this.baNotifyImpl);
        this.baBrokerImpl.start();
    }

    public void startForwarding() {
    }

    public void startBindingToDomMappingService() {
        BindingNormalizedNodeCodecRegistry codecRegistry = new BindingNormalizedNodeCodecRegistry();
        GeneratedClassLoadingStrategy loading = GeneratedClassLoadingStrategy.getTCCLClassLoadingStrategy();
        this.codec = new BindingToNormalizedNodeCodec((ClassLoadingStrategy)loading, codecRegistry);
        this.mockSchemaService.registerSchemaContextListener((SchemaContextListener)this.codec);
    }

    private void updateYangSchema(Set<YangModuleInfo> moduleInfos) {
        this.mockSchemaService.changeSchema(BindingTestContext.getContext(moduleInfos));
    }

    private static SchemaContext getContext(Set<YangModuleInfo> moduleInfos) {
        ModuleInfoBackedContext ctx = ModuleInfoBackedContext.create();
        ctx.addModuleInfos(moduleInfos);
        return (SchemaContext)ctx.tryToCreateSchemaContext().get();
    }

    public void start() {
        this.startNewDomDataBroker();
        this.startDomBroker();
        this.startDomMountPoint();
        this.startBindingToDomMappingService();
        this.startNewDataBroker();
        this.startBindingNotificationBroker();
        this.startBindingBroker();
        this.startForwarding();
        if (this.schemaModuleInfos != null) {
            this.updateYangSchema(this.schemaModuleInfos);
        } else if (this.startWithSchema) {
            this.loadYangSchemaFromClasspath();
        }
    }

    private void startDomMountPoint() {
        this.biMountImpl = new DOMMountPointServiceImpl();
    }

    private void startDomBroker() {
        Preconditions.checkState((this.executor != null ? 1 : 0) != 0);
        this.delegateDomRouter = DOMRpcRouter.newInstance((DOMSchemaService)this.mockSchemaService);
        this.domRouter = new org.opendaylight.controller.md.sal.dom.broker.impl.DOMRpcRouter(this.delegateDomRouter.getRpcService(), this.delegateDomRouter.getRpcProviderService());
    }

    public void startBindingNotificationBroker() {
        Preconditions.checkState((this.executor != null ? 1 : 0) != 0);
        DOMNotificationRouter router = DOMNotificationRouter.create((int)16);
        this.domPublishService = router;
        this.domListenService = router;
        this.publishService = new BindingDOMNotificationPublishServiceAdapter(this.codec, this.domPublishService);
        this.listenService = new BindingDOMNotificationServiceAdapter((BindingNormalizedNodeSerializer)this.codec, this.domListenService);
        this.baNotifyImpl = new HeliumNotificationProviderServiceAdapter(this.publishService, this.listenService);
    }

    public void loadYangSchemaFromClasspath() {
        this.updateYangSchema((Set<YangModuleInfo>)BindingReflections.loadModuleInfos());
    }

    public RpcProviderRegistry getBindingRpcRegistry() {
        return this.baBrokerImpl.getRoot();
    }

    public DOMRpcProviderService getDomRpcRegistry() {
        return this.domRouter;
    }

    public DOMRpcService getDomRpcInvoker() {
        return this.domRouter;
    }

    public DOMRpcRouter getDelegateDomRouter() {
        return this.delegateDomRouter;
    }

    @Override
    public void close() {
    }

    public MountPointService getBindingMountPointService() {
        return this.baBrokerImpl.getMountService();
    }

    public DOMMountPointService getDomMountProviderService() {
        return this.biMountImpl;
    }

    public DataBroker getDataBroker() {
        return this.dataBroker;
    }

    public void setSchemaModuleInfos(Set<YangModuleInfo> moduleInfos) {
        this.schemaModuleInfos = moduleInfos;
    }
}

