/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.compat;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataChangeListener;
import org.opendaylight.controller.md.sal.binding.api.ReadWriteTransaction;
import org.opendaylight.controller.md.sal.binding.compat.HydrogenDataChangeEvent;
import org.opendaylight.controller.md.sal.common.api.TransactionStatus;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeEvent;
import org.opendaylight.controller.md.sal.common.api.data.DataChangeEvent;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.sal.binding.api.data.DataModificationTransaction;
import org.opendaylight.controller.sal.binding.api.data.DataProviderService;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class HydrogenDataBrokerAdapter
implements DataProviderService,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(HydrogenDataBrokerAdapter.class);
    private final DataBroker delegate;

    public HydrogenDataBrokerAdapter(DataBroker dataBroker) {
        this.delegate = dataBroker;
        LOG.info("ForwardedBackwardsCompatibleBroker started.");
    }

    public DataModificationTransaction beginTransaction() {
        return new ForwardedBackwardsCompatibleTransacion(this.delegate.newReadWriteTransaction());
    }

    public DataObject readConfigurationData(InstanceIdentifier<? extends DataObject> path) {
        DataModificationTransaction tx = this.beginTransaction();
        return (DataObject)tx.readConfigurationData(path);
    }

    public DataObject readOperationalData(InstanceIdentifier<? extends DataObject> path) {
        DataModificationTransaction tx = this.beginTransaction();
        return (DataObject)tx.readOperationalData(path);
    }

    public ListenerRegistration<org.opendaylight.controller.sal.binding.api.data.DataChangeListener> registerDataChangeListener(InstanceIdentifier<? extends DataObject> path, org.opendaylight.controller.sal.binding.api.data.DataChangeListener listener) {
        BackwardsCompatibleOperationalDataChangeInvoker asyncOperListener = new BackwardsCompatibleOperationalDataChangeInvoker(listener);
        BackwardsCompatibleConfigurationDataChangeInvoker asyncCfgListener = new BackwardsCompatibleConfigurationDataChangeInvoker(listener);
        ListenerRegistration cfgReg = this.delegate.registerDataChangeListener(LogicalDatastoreType.CONFIGURATION, path, (DataChangeListener)asyncCfgListener, AsyncDataBroker.DataChangeScope.SUBTREE);
        ListenerRegistration operReg = this.delegate.registerDataChangeListener(LogicalDatastoreType.OPERATIONAL, path, (DataChangeListener)asyncOperListener, AsyncDataBroker.DataChangeScope.SUBTREE);
        return new LegacyListenerRegistration(listener, (ListenerRegistration<DataChangeListener>)cfgReg, (ListenerRegistration<DataChangeListener>)operReg);
    }

    @Override
    public void close() throws Exception {
    }

    private static class BackwardsCompatibleConfigurationDataChangeInvoker
    implements DataChangeListener,
    Delegator<org.opendaylight.controller.sal.binding.api.data.DataChangeListener> {
        private final org.opendaylight.controller.md.sal.common.api.data.DataChangeListener<?, ?> delegate;

        public BackwardsCompatibleConfigurationDataChangeInvoker(org.opendaylight.controller.sal.binding.api.data.DataChangeListener listener) {
            this.delegate = listener;
        }

        public void onDataChanged(AsyncDataChangeEvent<InstanceIdentifier<?>, DataObject> change) {
            DataChangeEvent<InstanceIdentifier<?>, DataObject> legacyChange = HydrogenDataChangeEvent.createConfiguration(change);
            this.delegate.onDataChanged(legacyChange);
        }

        public org.opendaylight.controller.sal.binding.api.data.DataChangeListener getDelegate() {
            return (org.opendaylight.controller.sal.binding.api.data.DataChangeListener)this.delegate;
        }
    }

    private static class BackwardsCompatibleOperationalDataChangeInvoker
    implements DataChangeListener,
    Delegator<org.opendaylight.controller.sal.binding.api.data.DataChangeListener> {
        private final org.opendaylight.controller.md.sal.common.api.data.DataChangeListener<?, ?> delegate;

        public BackwardsCompatibleOperationalDataChangeInvoker(org.opendaylight.controller.sal.binding.api.data.DataChangeListener listener) {
            this.delegate = listener;
        }

        public void onDataChanged(AsyncDataChangeEvent<InstanceIdentifier<?>, DataObject> change) {
            DataChangeEvent<InstanceIdentifier<?>, DataObject> legacyChange = HydrogenDataChangeEvent.createOperational(change);
            this.delegate.onDataChanged(legacyChange);
        }

        public org.opendaylight.controller.sal.binding.api.data.DataChangeListener getDelegate() {
            return (org.opendaylight.controller.sal.binding.api.data.DataChangeListener)this.delegate;
        }
    }

    private static final class LegacyListenerRegistration
    implements ListenerRegistration<org.opendaylight.controller.sal.binding.api.data.DataChangeListener> {
        private final org.opendaylight.controller.sal.binding.api.data.DataChangeListener instance;
        private final ListenerRegistration<DataChangeListener> cfgReg;
        private final ListenerRegistration<DataChangeListener> operReg;

        public LegacyListenerRegistration(org.opendaylight.controller.sal.binding.api.data.DataChangeListener listener, ListenerRegistration<DataChangeListener> cfgReg, ListenerRegistration<DataChangeListener> operReg) {
            this.instance = listener;
            this.cfgReg = cfgReg;
            this.operReg = operReg;
        }

        public org.opendaylight.controller.sal.binding.api.data.DataChangeListener getInstance() {
            return this.instance;
        }

        public void close() {
            this.cfgReg.close();
            this.operReg.close();
        }
    }

    @Deprecated
    private class ForwardedBackwardsCompatibleTransacion
    implements DataModificationTransaction {
        private final ListenerRegistry<DataModificationTransaction.DataTransactionListener> listeners = ListenerRegistry.create();
        private final Map<InstanceIdentifier<? extends DataObject>, DataObject> updated = new HashMap<InstanceIdentifier<? extends DataObject>, DataObject>();
        private final Map<InstanceIdentifier<? extends DataObject>, DataObject> created = new HashMap<InstanceIdentifier<? extends DataObject>, DataObject>();
        private final Set<InstanceIdentifier<? extends DataObject>> removed = new HashSet<InstanceIdentifier<? extends DataObject>>();
        private final Map<InstanceIdentifier<? extends DataObject>, DataObject> original = new HashMap<InstanceIdentifier<? extends DataObject>, DataObject>();
        private TransactionStatus status = TransactionStatus.NEW;
        private final Set<InstanceIdentifier<? extends DataObject>> posponedRemovedOperational = new HashSet<InstanceIdentifier<? extends DataObject>>();
        private final Set<InstanceIdentifier<? extends DataObject>> posponedRemovedConfiguration = new HashSet<InstanceIdentifier<? extends DataObject>>();
        private final ReadWriteTransaction delegate;

        public final TransactionStatus getStatus() {
            return this.status;
        }

        protected ForwardedBackwardsCompatibleTransacion(ReadWriteTransaction delegate) {
            this.delegate = delegate;
            LOG.debug("Tx {} allocated.", this.getIdentifier());
        }

        public void putOperationalData(InstanceIdentifier<? extends DataObject> path, DataObject data) {
            boolean previouslyRemoved = this.posponedRemovedOperational.remove(path);
            InstanceIdentifier<? extends DataObject> castedPath = path;
            if (previouslyRemoved) {
                this.delegate.put(LogicalDatastoreType.OPERATIONAL, castedPath, data, true);
            } else {
                this.delegate.merge(LogicalDatastoreType.OPERATIONAL, castedPath, data, true);
            }
        }

        public void putConfigurationData(InstanceIdentifier<? extends DataObject> path, DataObject data) {
            boolean previouslyRemoved = this.posponedRemovedConfiguration.remove(path);
            DataObject originalObj = this.readConfigurationData(path);
            if (originalObj != null) {
                this.original.put(path, originalObj);
            } else {
                this.created.put(path, data);
            }
            this.updated.put(path, data);
            InstanceIdentifier<? extends DataObject> castedPath = path;
            if (previouslyRemoved) {
                this.delegate.put(LogicalDatastoreType.CONFIGURATION, castedPath, data, true);
            } else {
                this.delegate.merge(LogicalDatastoreType.CONFIGURATION, castedPath, data, true);
            }
        }

        public void removeOperationalData(InstanceIdentifier<? extends DataObject> path) {
            this.posponedRemovedOperational.add(path);
        }

        public void removeConfigurationData(InstanceIdentifier<? extends DataObject> path) {
            this.posponedRemovedConfiguration.add(path);
        }

        public Map<InstanceIdentifier<? extends DataObject>, DataObject> getCreatedOperationalData() {
            return Collections.emptyMap();
        }

        public Map<InstanceIdentifier<? extends DataObject>, DataObject> getCreatedConfigurationData() {
            return this.created;
        }

        public Map<InstanceIdentifier<? extends DataObject>, DataObject> getUpdatedOperationalData() {
            return Collections.emptyMap();
        }

        public Map<InstanceIdentifier<? extends DataObject>, DataObject> getUpdatedConfigurationData() {
            return this.updated;
        }

        public Set<InstanceIdentifier<? extends DataObject>> getRemovedConfigurationData() {
            return this.removed;
        }

        public Set<InstanceIdentifier<? extends DataObject>> getRemovedOperationalData() {
            return Collections.emptySet();
        }

        public Map<InstanceIdentifier<? extends DataObject>, DataObject> getOriginalConfigurationData() {
            return this.original;
        }

        public Map<InstanceIdentifier<? extends DataObject>, DataObject> getOriginalOperationalData() {
            return Collections.emptyMap();
        }

        public DataObject readOperationalData(InstanceIdentifier<? extends DataObject> path) {
            try {
                return (DataObject)((Optional)this.delegate.read(LogicalDatastoreType.OPERATIONAL, path).get()).orNull();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Read of {} failed.", path, (Object)e);
                return null;
            }
        }

        public DataObject readConfigurationData(InstanceIdentifier<? extends DataObject> path) {
            try {
                return (DataObject)((Optional)this.delegate.read(LogicalDatastoreType.CONFIGURATION, path).get()).orNull();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Read of {} failed.", path, (Object)e);
                return null;
            }
        }

        private void changeStatus(TransactionStatus status) {
            LOG.trace("Transaction {} changed status to {}", this.getIdentifier(), (Object)status);
            this.status = status;
            for (ListenerRegistration listener : this.listeners) {
                try {
                    ((DataModificationTransaction.DataTransactionListener)listener.getInstance()).onStatusUpdated((DataModificationTransaction)this, status);
                }
                catch (Exception e) {
                    LOG.error("Error during invoking transaction listener {}", listener.getInstance(), (Object)e);
                }
            }
        }

        public ListenableFuture<RpcResult<TransactionStatus>> commit() {
            for (InstanceIdentifier<? extends DataObject> path : this.posponedRemovedConfiguration) {
                this.delegate.delete(LogicalDatastoreType.CONFIGURATION, path);
            }
            for (InstanceIdentifier<? extends DataObject> path : this.posponedRemovedOperational) {
                this.delegate.delete(LogicalDatastoreType.OPERATIONAL, path);
            }
            this.changeStatus(TransactionStatus.SUBMITED);
            ListenableFuture f = this.delegate.commit();
            Futures.addCallback((ListenableFuture)f, (FutureCallback)new FutureCallback<RpcResult<TransactionStatus>>(){

                public void onSuccess(RpcResult<TransactionStatus> result) {
                    ForwardedBackwardsCompatibleTransacion.this.changeStatus((TransactionStatus)result.getResult());
                }

                public void onFailure(Throwable t) {
                    LOG.error("Transaction {} failed to complete", ForwardedBackwardsCompatibleTransacion.this.getIdentifier(), (Object)t);
                    ForwardedBackwardsCompatibleTransacion.this.changeStatus(TransactionStatus.FAILED);
                }
            });
            return f;
        }

        public ListenerRegistration<DataModificationTransaction.DataTransactionListener> registerListener(DataModificationTransaction.DataTransactionListener listener) {
            return this.listeners.register((EventListener)listener);
        }

        public Object getIdentifier() {
            return null;
        }
    }
}

