/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.md.sal.binding.api.ClusteredDataChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataChangeListener;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeEvent;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeListener;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.dom.api.ClusteredDOMDataChangeListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMDataChangeListener;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.codec.DeserializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractForwardedDataBroker
implements Delegator<DOMDataBroker>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractForwardedDataBroker.class);
    private final DOMDataBroker domDataBroker;
    private final BindingToNormalizedNodeCodec codec;

    protected AbstractForwardedDataBroker(DOMDataBroker domDataBroker, BindingToNormalizedNodeCodec codec, SchemaService schemaService) {
        this.domDataBroker = domDataBroker;
        this.codec = codec;
    }

    protected AbstractForwardedDataBroker(DOMDataBroker domDataBroker, BindingToNormalizedNodeCodec codec) {
        this.domDataBroker = domDataBroker;
        this.codec = codec;
    }

    protected BindingToNormalizedNodeCodec getCodec() {
        return this.codec;
    }

    public DOMDataBroker getDelegate() {
        return this.domDataBroker;
    }

    public ListenerRegistration<DataChangeListener> registerDataChangeListener(LogicalDatastoreType store, InstanceIdentifier<?> path, DataChangeListener listener, AsyncDataBroker.DataChangeScope triggeringScope) {
        TranslatingDataChangeInvoker domDataChangeListener = listener instanceof ClusteredDataChangeListener ? new TranslatingClusteredDataChangeInvoker(store, path, listener, triggeringScope) : new TranslatingDataChangeInvoker(store, path, listener, triggeringScope);
        YangInstanceIdentifier domPath = this.codec.toYangInstanceIdentifierBlocking(path);
        ListenerRegistration domRegistration = this.domDataBroker.registerDataChangeListener(store, (Path)domPath, (AsyncDataChangeListener)domDataChangeListener, triggeringScope);
        return new ListenerRegistrationImpl(listener, (ListenerRegistration<DOMDataChangeListener>)domRegistration);
    }

    protected Map<InstanceIdentifier<?>, DataObject> toBinding(InstanceIdentifier<?> path, Map<YangInstanceIdentifier, ? extends NormalizedNode<?, ?>> normalized) {
        HashMap newMap = new HashMap();
        for (Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> entry : normalized.entrySet()) {
            try {
                Optional<Map.Entry<InstanceIdentifier<? extends DataObject>, DataObject>> potential = this.getCodec().toBinding(entry);
                if (!potential.isPresent()) continue;
                Map.Entry binding = (Map.Entry)potential.get();
                newMap.put((InstanceIdentifier<?>)binding.getKey(), (DataObject)binding.getValue());
            }
            catch (DeserializationException e) {
                LOG.warn("Failed to transform {}, omitting it", entry, (Object)e);
            }
        }
        return newMap;
    }

    protected Set<InstanceIdentifier<?>> toBinding(InstanceIdentifier<?> path, Set<YangInstanceIdentifier> normalized) {
        HashSet hashSet = new HashSet();
        for (YangInstanceIdentifier normalizedPath : normalized) {
            try {
                Optional<InstanceIdentifier<? extends DataObject>> potential = this.getCodec().toBinding(normalizedPath);
                if (potential.isPresent()) {
                    InstanceIdentifier binding = (InstanceIdentifier)potential.get();
                    hashSet.add(binding);
                    continue;
                }
                if (!(normalizedPath.getLastPathArgument() instanceof YangInstanceIdentifier.AugmentationIdentifier)) continue;
                hashSet.add(path);
            }
            catch (DeserializationException e) {
                LOG.warn("Failed to transform {}, omitting it", (Object)normalizedPath, (Object)e);
            }
        }
        return hashSet;
    }

    protected Optional<DataObject> toBindingData(InstanceIdentifier<?> path, NormalizedNode<?, ?> data) {
        if (path.isWildcarded()) {
            return Optional.absent();
        }
        return (Optional)this.getCodec().deserializeFunction(path).apply((Object)Optional.of(data));
    }

    @Override
    public void close() {
    }

    private static class ListenerRegistrationImpl
    extends AbstractListenerRegistration<DataChangeListener> {
        private final ListenerRegistration<DOMDataChangeListener> registration;

        public ListenerRegistrationImpl(DataChangeListener listener, ListenerRegistration<DOMDataChangeListener> registration) {
            super((EventListener)listener);
            this.registration = registration;
        }

        protected void removeRegistration() {
            this.registration.close();
        }
    }

    private class TranslatedDataChangeEvent
    implements AsyncDataChangeEvent<InstanceIdentifier<?>, DataObject> {
        private final AsyncDataChangeEvent<YangInstanceIdentifier, NormalizedNode<?, ?>> domEvent;
        private final InstanceIdentifier<?> path;
        private Map<InstanceIdentifier<?>, DataObject> createdCache;
        private Map<InstanceIdentifier<?>, DataObject> updatedCache;
        private Map<InstanceIdentifier<?>, DataObject> originalCache;
        private Set<InstanceIdentifier<?>> removedCache;
        private Optional<DataObject> originalDataCache;
        private Optional<DataObject> updatedDataCache;

        public TranslatedDataChangeEvent(AsyncDataChangeEvent<YangInstanceIdentifier, NormalizedNode<?, ?>> change, InstanceIdentifier<?> path) {
            this.domEvent = change;
            this.path = path;
        }

        public Map<InstanceIdentifier<?>, DataObject> getCreatedData() {
            if (this.createdCache == null) {
                this.createdCache = Collections.unmodifiableMap(AbstractForwardedDataBroker.this.toBinding(this.path, this.domEvent.getCreatedData()));
            }
            return this.createdCache;
        }

        public Map<InstanceIdentifier<?>, DataObject> getUpdatedData() {
            if (this.updatedCache == null) {
                this.updatedCache = Collections.unmodifiableMap(AbstractForwardedDataBroker.this.toBinding(this.path, this.domEvent.getUpdatedData()));
            }
            return this.updatedCache;
        }

        public Set<InstanceIdentifier<?>> getRemovedPaths() {
            if (this.removedCache == null) {
                this.removedCache = Collections.unmodifiableSet(AbstractForwardedDataBroker.this.toBinding(this.path, this.domEvent.getRemovedPaths()));
            }
            return this.removedCache;
        }

        public Map<InstanceIdentifier<?>, DataObject> getOriginalData() {
            if (this.originalCache == null) {
                this.originalCache = Collections.unmodifiableMap(AbstractForwardedDataBroker.this.toBinding(this.path, this.domEvent.getOriginalData()));
            }
            return this.originalCache;
        }

        public DataObject getOriginalSubtree() {
            if (this.originalDataCache == null) {
                this.originalDataCache = this.domEvent.getOriginalSubtree() != null ? AbstractForwardedDataBroker.this.toBindingData(this.path, (NormalizedNode)this.domEvent.getOriginalSubtree()) : Optional.absent();
            }
            return (DataObject)this.originalDataCache.orNull();
        }

        public DataObject getUpdatedSubtree() {
            if (this.updatedDataCache == null) {
                this.updatedDataCache = this.domEvent.getUpdatedSubtree() != null ? AbstractForwardedDataBroker.this.toBindingData(this.path, (NormalizedNode)this.domEvent.getUpdatedSubtree()) : Optional.absent();
            }
            return (DataObject)this.updatedDataCache.orNull();
        }

        public String toString() {
            return MoreObjects.toStringHelper(TranslatedDataChangeEvent.class).add("created", this.getCreatedData()).add("updated", this.getUpdatedData()).add("removed", this.getRemovedPaths()).add("dom", this.domEvent).toString();
        }
    }

    private class TranslatingClusteredDataChangeInvoker
    extends TranslatingDataChangeInvoker
    implements ClusteredDOMDataChangeListener {
        public TranslatingClusteredDataChangeInvoker(LogicalDatastoreType store, InstanceIdentifier<?> path, DataChangeListener bindingDataChangeListener, AsyncDataBroker.DataChangeScope triggeringScope) {
            super(store, path, bindingDataChangeListener, triggeringScope);
        }
    }

    private class TranslatingDataChangeInvoker
    implements DOMDataChangeListener {
        private final DataChangeListener bindingDataChangeListener;
        private final LogicalDatastoreType store;
        private final InstanceIdentifier<?> path;
        private final AsyncDataBroker.DataChangeScope triggeringScope;

        public TranslatingDataChangeInvoker(LogicalDatastoreType store, InstanceIdentifier<?> path, DataChangeListener bindingDataChangeListener, AsyncDataBroker.DataChangeScope triggeringScope) {
            this.store = store;
            this.path = path;
            this.bindingDataChangeListener = bindingDataChangeListener;
            this.triggeringScope = triggeringScope;
        }

        public void onDataChanged(AsyncDataChangeEvent<YangInstanceIdentifier, NormalizedNode<?, ?>> change) {
            this.bindingDataChangeListener.onDataChanged((AsyncDataChangeEvent)new TranslatedDataChangeEvent(change, this.path));
        }

        public String toString() {
            return this.bindingDataChangeListener.getClass().getName();
        }
    }
}

