/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.opendaylight.controller.md.sal.binding.impl.AbstractWriteTransaction;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.md.sal.common.impl.util.compat.DataNormalizationException;
import org.opendaylight.controller.md.sal.common.impl.util.compat.DataNormalizationOperation;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadWriteTransaction;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractReadWriteTransaction
extends AbstractWriteTransaction<DOMDataReadWriteTransaction> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReadWriteTransaction.class);

    public AbstractReadWriteTransaction(DOMDataReadWriteTransaction delegate, BindingToNormalizedNodeCodec codec) {
        super(delegate, codec);
    }

    @Override
    protected final void ensureParentsByMerge(LogicalDatastoreType store, YangInstanceIdentifier normalizedPath, InstanceIdentifier<?> path) {
        ArrayList<YangInstanceIdentifier.PathArgument> currentArguments = new ArrayList<YangInstanceIdentifier.PathArgument>();
        DataNormalizationOperation currentOp = this.getCodec().getDataNormalizer().getRootOperation();
        Iterator iterator = normalizedPath.getPathArguments().iterator();
        while (iterator.hasNext()) {
            Boolean exists;
            YangInstanceIdentifier.PathArgument currentArg = (YangInstanceIdentifier.PathArgument)iterator.next();
            try {
                currentOp = currentOp.getChild(currentArg);
            }
            catch (DataNormalizationException e) {
                throw new IllegalArgumentException(String.format("Invalid child encountered in path %s", path), e);
            }
            currentArguments.add(currentArg);
            YangInstanceIdentifier currentPath = YangInstanceIdentifier.create(currentArguments);
            try {
                exists = (Boolean)((DOMDataReadWriteTransaction)this.getDelegate()).exists(store, currentPath).checkedGet();
            }
            catch (ReadFailedException e) {
                LOG.error("Failed to read pre-existing data from store {} path {}", new Object[]{store, currentPath, e});
                throw new IllegalStateException("Failed to read pre-existing data", e);
            }
            if (exists.booleanValue() || !iterator.hasNext()) continue;
            ((DOMDataReadWriteTransaction)this.getDelegate()).merge(store, currentPath, currentOp.createDefault(currentArg));
        }
    }
}

