/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.opendaylight.controller.md.sal.binding.impl.LazyDOMRpcResultFuture;
import org.opendaylight.controller.md.sal.binding.impl.LazySerializedContainerNode;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcException;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcIdentifier;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementation;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.binding.util.BindingReflections;
import org.opendaylight.yangtools.yang.binding.util.RpcServiceInvoker;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public class BindingDOMRpcImplementationAdapter
implements DOMRpcImplementation {
    private static final Cache<Class<?>, RpcServiceInvoker> SERVICE_INVOKERS = CacheBuilder.newBuilder().weakKeys().build();
    private final BindingNormalizedNodeSerializer codec;
    private final RpcServiceInvoker invoker;
    private final RpcService delegate;
    private final QName inputQname;

    public <T extends RpcService> BindingDOMRpcImplementationAdapter(BindingNormalizedNodeSerializer codec, Class<T> type, final Map<SchemaPath, Method> localNameToMethod, T delegate) {
        try {
            this.invoker = (RpcServiceInvoker)SERVICE_INVOKERS.get(type, (Callable)new Callable<RpcServiceInvoker>(){

                @Override
                public RpcServiceInvoker call() {
                    HashMap map = new HashMap();
                    for (Map.Entry e : localNameToMethod.entrySet()) {
                        map.put(((SchemaPath)e.getKey()).getLastComponent(), e.getValue());
                    }
                    return RpcServiceInvoker.from(map);
                }
            });
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException("Failed to create invokers for type " + type, e);
        }
        this.codec = (BindingNormalizedNodeSerializer)Preconditions.checkNotNull((Object)codec);
        this.delegate = (RpcService)Preconditions.checkNotNull(delegate);
        this.inputQname = QName.create((QNameModule)BindingReflections.getQNameModule(type), (String)"input").intern();
    }

    public CheckedFuture<DOMRpcResult, DOMRpcException> invokeRpc(DOMRpcIdentifier rpc, NormalizedNode<?, ?> input) {
        SchemaPath schemaPath = rpc.getType();
        DataObject bindingInput = input != null ? this.deserilialize(rpc.getType(), input) : null;
        ListenableFuture<RpcResult<?>> bindingResult = this.invoke(schemaPath, bindingInput);
        return this.transformResult(schemaPath, bindingResult);
    }

    private DataObject deserilialize(SchemaPath rpcPath, NormalizedNode<?, ?> input) {
        if (input instanceof LazySerializedContainerNode) {
            return ((LazySerializedContainerNode)input).bindingData();
        }
        SchemaPath inputSchemaPath = rpcPath.createChild(new QName[]{this.inputQname});
        return this.codec.fromNormalizedNodeRpcData(inputSchemaPath, (ContainerNode)input);
    }

    private ListenableFuture<RpcResult<?>> invoke(SchemaPath schemaPath, DataObject input) {
        return JdkFutureAdapters.listenInPoolThread((Future)this.invoker.invokeRpc(this.delegate, schemaPath.getLastComponent(), input));
    }

    private CheckedFuture<DOMRpcResult, DOMRpcException> transformResult(SchemaPath schemaPath, ListenableFuture<RpcResult<?>> bindingResult) {
        return LazyDOMRpcResultFuture.create(this.codec, bindingResult);
    }
}

