/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import org.opendaylight.controller.md.sal.binding.api.BindingTransactionChain;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.binding.api.ReadWriteTransaction;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMReadTransactionAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMReadWriteTransactionAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMWriteTransactionAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.common.api.data.AsyncTransaction;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChain;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChainListener;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadOnlyTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMTransactionChain;
import org.opendaylight.yangtools.concepts.Delegator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BindingDOMTransactionChainAdapter
implements BindingTransactionChain,
Delegator<DOMTransactionChain> {
    private static final Logger LOG = LoggerFactory.getLogger(BindingDOMTransactionChainAdapter.class);
    private final DOMTransactionChain delegate;
    private final BindingToNormalizedNodeCodec codec;
    private final DelegateChainListener domListener;
    private final TransactionChainListener bindingListener;

    public BindingDOMTransactionChainAdapter(DOMDataBroker chainFactory, BindingToNormalizedNodeCodec codec, TransactionChainListener listener) {
        Preconditions.checkNotNull((Object)chainFactory, (Object)"DOM Transaction chain factory must not be null");
        this.domListener = new DelegateChainListener();
        this.bindingListener = listener;
        this.delegate = chainFactory.createTransactionChain((TransactionChainListener)this.domListener);
        this.codec = codec;
    }

    public DOMTransactionChain getDelegate() {
        return this.delegate;
    }

    public ReadOnlyTransaction newReadOnlyTransaction() {
        DOMDataReadOnlyTransaction delegateTx = this.delegate.newReadOnlyTransaction();
        return new BindingDOMReadTransactionAdapter(delegateTx, this.codec);
    }

    public ReadWriteTransaction newReadWriteTransaction() {
        DOMDataReadWriteTransaction delegateTx = this.delegate.newReadWriteTransaction();
        return new BindingDOMReadWriteTransactionAdapter(delegateTx, this.codec){

            @Override
            public CheckedFuture<Void, TransactionCommitFailedException> submit() {
                return BindingDOMTransactionChainAdapter.this.listenForFailure(this, (CheckedFuture<Void, TransactionCommitFailedException>)super.submit());
            }
        };
    }

    public WriteTransaction newWriteOnlyTransaction() {
        DOMDataWriteTransaction delegateTx = this.delegate.newWriteOnlyTransaction();
        return new BindingDOMWriteTransactionAdapter<DOMDataWriteTransaction>(delegateTx, this.codec){

            @Override
            public CheckedFuture<Void, TransactionCommitFailedException> submit() {
                return BindingDOMTransactionChainAdapter.this.listenForFailure(this, (CheckedFuture<Void, TransactionCommitFailedException>)super.submit());
            }
        };
    }

    private CheckedFuture<Void, TransactionCommitFailedException> listenForFailure(final WriteTransaction tx, CheckedFuture<Void, TransactionCommitFailedException> future) {
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Void>(){

            public void onFailure(Throwable t) {
                BindingDOMTransactionChainAdapter.this.failTransactionChain(tx, t);
            }

            public void onSuccess(Void result) {
            }
        });
        return future;
    }

    private void failTransactionChain(WriteTransaction tx, Throwable t) {
        this.bindingListener.onTransactionChainFailed((TransactionChain)this, (AsyncTransaction)tx, t);
    }

    public void close() {
        this.delegate.close();
    }

    private final class DelegateChainListener
    implements TransactionChainListener {
        private DelegateChainListener() {
        }

        public void onTransactionChainFailed(TransactionChain<?, ?> chain, AsyncTransaction<?, ?> transaction, Throwable cause) {
            Preconditions.checkState((boolean)BindingDOMTransactionChainAdapter.this.delegate.equals(chain), (String)"Illegal state - listener for %s was invoked for incorrect chain %s.", (Object[])new Object[]{BindingDOMTransactionChainAdapter.this.delegate, chain});
            LOG.debug("Transaction chain {} failed. Failed DOM Transaction {}", new Object[]{this, transaction, cause});
        }

        public void onTransactionChainSuccessful(TransactionChain<?, ?> chain) {
            Preconditions.checkState((boolean)BindingDOMTransactionChainAdapter.this.delegate.equals(chain), (String)"Illegal state - listener for %s was invoked for incorrect chain %s.", (Object[])new Object[]{BindingDOMTransactionChainAdapter.this.delegate, chain});
            BindingDOMTransactionChainAdapter.this.bindingListener.onTransactionChainSuccessful((TransactionChain)BindingDOMTransactionChainAdapter.this);
        }
    }
}

