/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.opendaylight.controller.md.sal.binding.api.BindingService;
import org.opendaylight.controller.md.sal.binding.api.MountPoint;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMAdapterLoader;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPoint;
import org.opendaylight.controller.md.sal.dom.api.DOMService;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class BindingMountPointAdapter
implements MountPoint {
    private final InstanceIdentifier<?> identifier;
    private LoadingCache<Class<? extends BindingService>, Optional<BindingService>> services;

    public BindingMountPointAdapter(BindingToNormalizedNodeCodec codec, final DOMMountPoint domMountPoint) {
        this.identifier = codec.getCodecRegistry().fromYangInstanceIdentifier((YangInstanceIdentifier)domMountPoint.getIdentifier());
        this.services = CacheBuilder.newBuilder().build((CacheLoader)new BindingDOMAdapterLoader(codec){

            @Override
            protected DOMService getDelegate(Class<? extends DOMService> reqDeleg) {
                return (DOMService)domMountPoint.getService(reqDeleg).orNull();
            }
        });
    }

    public InstanceIdentifier<?> getIdentifier() {
        return this.identifier;
    }

    public <T extends BindingService> Optional<T> getService(Class<T> service) {
        Optional potential = (Optional)this.services.getUnchecked(service);
        if (potential.isPresent()) {
            return Optional.of(service.cast(potential.get()));
        }
        return Optional.absent();
    }
}

