/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;

enum BindingStructuralType {
    NOT_ADDRESSABLE,
    INVISIBLE_CONTAINER,
    INVISIBLE_LIST,
    VISIBLE_CONTAINER,
    UNKNOWN;


    static BindingStructuralType from(DataTreeCandidateNode domChildNode) {
        Optional dataBased = domChildNode.getDataAfter().or(domChildNode.getDataBefore());
        if (dataBased.isPresent()) {
            return BindingStructuralType.from((NormalizedNode)dataBased.get());
        }
        return BindingStructuralType.from(domChildNode.getIdentifier());
    }

    private static BindingStructuralType from(YangInstanceIdentifier.PathArgument identifier) {
        if (identifier instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates || identifier instanceof YangInstanceIdentifier.AugmentationIdentifier) {
            return VISIBLE_CONTAINER;
        }
        if (identifier instanceof YangInstanceIdentifier.NodeWithValue) {
            return NOT_ADDRESSABLE;
        }
        return UNKNOWN;
    }

    static BindingStructuralType from(NormalizedNode<?, ?> data) {
        if (BindingStructuralType.isNotAddressable(data)) {
            return NOT_ADDRESSABLE;
        }
        if (data instanceof MapNode) {
            return INVISIBLE_LIST;
        }
        if (data instanceof ChoiceNode) {
            return INVISIBLE_CONTAINER;
        }
        if (BindingStructuralType.isVisibleContainer(data)) {
            return VISIBLE_CONTAINER;
        }
        return UNKNOWN;
    }

    private static boolean isVisibleContainer(NormalizedNode<?, ?> data) {
        return data instanceof MapEntryNode || data instanceof ContainerNode || data instanceof AugmentationNode;
    }

    private static boolean isNotAddressable(NormalizedNode<?, ?> d) {
        return d instanceof LeafNode || d instanceof AnyXmlNode || d instanceof LeafSetNode || d instanceof LeafSetEntryNode;
    }
}

