/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.SettableFuture;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.yangtools.sal.binding.generator.util.BindingRuntimeContext;
import org.opendaylight.yangtools.yang.binding.Augmentation;

class FutureSchema
implements AutoCloseable {
    @GuardedBy(value="postponedOperations")
    private final Set<FutureSchemaPredicate> postponedOperations = new LinkedHashSet<FutureSchemaPredicate>();
    private final long duration;
    private final TimeUnit unit;
    private final boolean waitEnabled;
    private volatile BindingRuntimeContext runtimeContext;

    protected FutureSchema(long time, TimeUnit unit, boolean waitEnabled) {
        this.duration = time;
        this.unit = unit;
        this.waitEnabled = waitEnabled;
    }

    BindingRuntimeContext runtimeContext() {
        BindingRuntimeContext localRuntimeContext = this.runtimeContext;
        if (localRuntimeContext != null) {
            return localRuntimeContext;
        }
        if (this.waitForSchema(Collections.emptyList())) {
            return this.runtimeContext;
        }
        throw new IllegalStateException("No SchemaContext is available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onRuntimeContextUpdated(BindingRuntimeContext context) {
        Set<FutureSchemaPredicate> set = this.postponedOperations;
        synchronized (set) {
            this.runtimeContext = context;
            for (FutureSchemaPredicate op : this.postponedOperations) {
                op.unlockIfPossible(context);
            }
        }
    }

    long getDuration() {
        return this.duration;
    }

    TimeUnit getUnit() {
        return this.unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Set<FutureSchemaPredicate> set = this.postponedOperations;
        synchronized (set) {
            for (FutureSchemaPredicate op : this.postponedOperations) {
                op.cancel();
            }
        }
    }

    private static boolean isSchemaAvailable(Class<?> clz, BindingRuntimeContext context) {
        Object schema = Augmentation.class.isAssignableFrom(clz) ? context.getAugmentationDefinition(clz) : context.getSchemaDefinition(clz);
        return schema != null;
    }

    boolean waitForSchema(final URI namespace, final Date revision) {
        return this.addPostponedOpAndWait(new FutureSchemaPredicate(){

            public boolean apply(BindingRuntimeContext input) {
                return input.getSchemaContext().findModuleByNamespaceAndRevision(namespace, revision) != null;
            }
        });
    }

    boolean waitForSchema(final Collection<Class<?>> bindingClasses) {
        return this.addPostponedOpAndWait(new FutureSchemaPredicate(){

            public boolean apply(BindingRuntimeContext context) {
                for (Class clz : bindingClasses) {
                    if (FutureSchema.isSchemaAvailable(clz, context)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addPostponedOpAndWait(FutureSchemaPredicate postponedOp) {
        if (!this.waitEnabled) {
            return false;
        }
        BindingRuntimeContext localRuntimeContext = this.runtimeContext;
        Set<FutureSchemaPredicate> set = this.postponedOperations;
        synchronized (set) {
            this.postponedOperations.add(postponedOp);
            if (localRuntimeContext != this.runtimeContext) {
                postponedOp.unlockIfPossible(this.runtimeContext);
            }
        }
        return postponedOp.waitForSchema();
    }

    private abstract class FutureSchemaPredicate
    implements Predicate<BindingRuntimeContext> {
        private final SettableFuture<?> schemaPromise = SettableFuture.create();

        private FutureSchemaPredicate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean waitForSchema() {
            try {
                this.schemaPromise.get(FutureSchema.this.duration, FutureSchema.this.unit);
                boolean bl = true;
                return bl;
            }
            catch (InterruptedException | ExecutionException e) {
                throw Throwables.propagate((Throwable)e);
            }
            catch (TimeoutException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                Set set = FutureSchema.this.postponedOperations;
                synchronized (set) {
                    FutureSchema.this.postponedOperations.remove(this);
                }
            }
        }

        final void unlockIfPossible(BindingRuntimeContext context) {
            if (!this.schemaPromise.isDone() && this.apply(context)) {
                this.schemaPromise.set(null);
            }
        }

        final void cancel() {
            this.schemaPromise.cancel(true);
        }
    }
}

