/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.opendaylight.controller.md.sal.binding.api.DataObjectModification;
import org.opendaylight.controller.md.sal.binding.impl.BindingStructuralType;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeNode;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LazyDataObjectModification<T extends DataObject>
implements DataObjectModification<T> {
    private static final Logger LOG = LoggerFactory.getLogger(LazyDataObjectModification.class);
    private final BindingCodecTreeNode<T> codec;
    private final DataTreeCandidateNode domData;
    private final InstanceIdentifier.PathArgument identifier;
    private Collection<DataObjectModification<? extends DataObject>> childNodesCache;

    private LazyDataObjectModification(BindingCodecTreeNode<T> codec, DataTreeCandidateNode domData) {
        this.codec = (BindingCodecTreeNode)Preconditions.checkNotNull(codec);
        this.domData = (DataTreeCandidateNode)Preconditions.checkNotNull((Object)domData);
        this.identifier = codec.deserializePathArgument(domData.getIdentifier());
    }

    static <T extends DataObject> DataObjectModification<T> create(BindingCodecTreeNode<T> codec, DataTreeCandidateNode domData) {
        return new LazyDataObjectModification<T>(codec, domData);
    }

    private static Collection<DataObjectModification<? extends DataObject>> from(BindingCodecTreeNode<?> parentCodec, Collection<DataTreeCandidateNode> domChildNodes) {
        ArrayList<DataObjectModification<? extends DataObject>> result = new ArrayList<DataObjectModification<? extends DataObject>>(domChildNodes.size());
        LazyDataObjectModification.populateList(result, parentCodec, domChildNodes);
        return result;
    }

    private static void populateList(List<DataObjectModification<? extends DataObject>> result, BindingCodecTreeNode<?> parentCodec, Collection<DataTreeCandidateNode> domChildNodes) {
        for (DataTreeCandidateNode domChildNode : domChildNodes) {
            BindingStructuralType type = BindingStructuralType.from(domChildNode);
            if (type == BindingStructuralType.NOT_ADDRESSABLE) continue;
            try {
                BindingCodecTreeNode childCodec = parentCodec.yangPathArgumentChild(domChildNode.getIdentifier());
                LazyDataObjectModification.populateList(result, type, childCodec, domChildNode);
            }
            catch (IllegalArgumentException e) {
                if (type == BindingStructuralType.UNKNOWN) {
                    LOG.debug("Unable to deserialize unknown DOM node {}", (Object)domChildNode, (Object)e);
                    continue;
                }
                LOG.debug("Binding representation for DOM node {} was not found", (Object)domChildNode, (Object)e);
            }
        }
    }

    private static void populateList(List<DataObjectModification<? extends DataObject>> result, BindingStructuralType type, BindingCodecTreeNode<?> childCodec, DataTreeCandidateNode domChildNode) {
        switch (type) {
            case INVISIBLE_LIST: {
                LazyDataObjectModification.populateListWithSingleCodec(result, childCodec, domChildNode.getChildNodes());
                break;
            }
            case INVISIBLE_CONTAINER: {
                LazyDataObjectModification.populateList(result, childCodec, domChildNode.getChildNodes());
                break;
            }
            case UNKNOWN: 
            case VISIBLE_CONTAINER: {
                result.add(LazyDataObjectModification.create(childCodec, domChildNode));
            }
        }
    }

    private static void populateListWithSingleCodec(List<DataObjectModification<? extends DataObject>> result, BindingCodecTreeNode<?> codec, Collection<DataTreeCandidateNode> childNodes) {
        for (DataTreeCandidateNode child : childNodes) {
            result.add(LazyDataObjectModification.create(codec, child));
        }
    }

    public T getDataBefore() {
        return this.deserialize(this.domData.getDataBefore());
    }

    public T getDataAfter() {
        return this.deserialize(this.domData.getDataAfter());
    }

    public Class<T> getDataType() {
        return this.codec.getBindingClass();
    }

    public InstanceIdentifier.PathArgument getIdentifier() {
        return this.identifier;
    }

    public DataObjectModification.ModificationType getModificationType() {
        switch (this.domData.getModificationType()) {
            case WRITE: {
                return DataObjectModification.ModificationType.WRITE;
            }
            case APPEARED: 
            case SUBTREE_MODIFIED: {
                return DataObjectModification.ModificationType.SUBTREE_MODIFIED;
            }
            case DISAPPEARED: 
            case DELETE: {
                return DataObjectModification.ModificationType.DELETE;
            }
        }
        throw new IllegalStateException("Unsupported DOM Modification type " + this.domData.getModificationType());
    }

    public Collection<DataObjectModification<? extends DataObject>> getModifiedChildren() {
        if (this.childNodesCache == null) {
            this.childNodesCache = LazyDataObjectModification.from(this.codec, this.domData.getChildNodes());
        }
        return this.childNodesCache;
    }

    public DataObjectModification<? extends DataObject> getModifiedChild(InstanceIdentifier.PathArgument arg) {
        DataTreeCandidateNode current;
        ArrayList domArgumentList = new ArrayList();
        BindingCodecTreeNode childCodec = this.codec.bindingPathArgumentChild(arg, domArgumentList);
        Iterator toEnter = domArgumentList.iterator();
        for (current = this.domData; toEnter.hasNext() && current != null; current = current.getModifiedChild((YangInstanceIdentifier.PathArgument)toEnter.next())) {
        }
        if (current != null) {
            return LazyDataObjectModification.create(childCodec, current);
        }
        return null;
    }

    public <C extends Identifiable<K> & ChildOf<? super T>, K extends Identifier<C>> DataObjectModification<C> getModifiedChildListItem(Class<C> listItem, K listKey) {
        return this.getModifiedChild((InstanceIdentifier.PathArgument)new InstanceIdentifier.IdentifiableItem(listItem, listKey));
    }

    public <C extends ChildOf<? super T>> DataObjectModification<C> getModifiedChildContainer(Class<C> arg) {
        return this.getModifiedChild((InstanceIdentifier.PathArgument)new InstanceIdentifier.Item(arg));
    }

    public <C extends Augmentation<T> & DataObject> DataObjectModification<C> getModifiedAugmentation(Class<C> augmentation) {
        return this.getModifiedChild((InstanceIdentifier.PathArgument)new InstanceIdentifier.Item(augmentation));
    }

    private T deserialize(Optional<NormalizedNode<?, ?>> dataAfter) {
        if (dataAfter.isPresent()) {
            return (T)this.codec.deserialize((NormalizedNode)dataAfter.get());
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{identifier = " + this.identifier + ", domData = " + this.domData + "}";
    }
}

