/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.compat;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.opendaylight.controller.md.sal.binding.compat.NotificationListenerRegistration;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NotifyTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(NotifyTask.class);
    private final NotificationListenerRegistration<?> registration;
    private final Notification notification;

    public NotifyTask(NotificationListenerRegistration<?> registration, Notification notification) {
        this.registration = (NotificationListenerRegistration)Preconditions.checkNotNull(registration);
        this.notification = (Notification)Preconditions.checkNotNull((Object)notification);
    }

    private <T extends Notification> NotificationListenerRegistration<T> getRegistration() {
        return this.registration;
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Delivering notification {} to {}", (Object)this.notification, this.registration.getInstance());
        } else {
            LOG.trace("Delivering notification {} to {}", (Object)this.notification.getClass().getName(), this.registration.getInstance());
        }
        try {
            this.getRegistration().notify(this.notification);
        }
        catch (Exception e) {
            LOG.error("Unhandled exception thrown by listener: {}", this.registration.getInstance(), (Object)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Notification delivered {} to {}", (Object)this.notification, this.registration.getInstance());
        } else {
            LOG.trace("Notification delivered {} to {}", (Object)this.notification.getClass().getName(), this.registration.getInstance());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.registration == null ? 0 : this.registration.hashCode());
        result = 31 * result + (this.notification == null ? 0 : this.notification.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NotifyTask other = (NotifyTask)obj;
        if (this.registration == null ? other.registration != null : !this.registration.equals(other.registration)) {
            return false;
        }
        return !(this.notification == null ? other.notification != null : !this.notification.equals(other.notification));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("listener", this.registration).add("notification", this.notification.getClass()).toString();
    }
}

