/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.common.api.data.AsyncTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadTransaction;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.util.concurrent.MappingCheckedFuture;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

abstract class AbstractForwardedTransaction<T extends AsyncTransaction<YangInstanceIdentifier, NormalizedNode<?, ?>>>
implements Delegator<T>,
Identifiable<Object> {
    private final T delegate;
    private final BindingToNormalizedNodeCodec codec;

    public AbstractForwardedTransaction(T delegateTx, BindingToNormalizedNodeCodec codec) {
        this.delegate = (AsyncTransaction)Preconditions.checkNotNull(delegateTx, (Object)"Delegate must not be null");
        this.codec = (BindingToNormalizedNodeCodec)Preconditions.checkNotNull((Object)codec, (Object)"Codec must not be null");
    }

    public final Object getIdentifier() {
        return this.delegate.getIdentifier();
    }

    public final T getDelegate() {
        return this.delegate;
    }

    protected final <S extends AsyncTransaction<YangInstanceIdentifier, NormalizedNode<?, ?>>> S getDelegateChecked(Class<S> txType) {
        Preconditions.checkState((boolean)txType.isInstance(this.delegate));
        return (S)this.delegate;
    }

    protected final BindingToNormalizedNodeCodec getCodec() {
        return this.codec;
    }

    protected final <D extends DataObject> CheckedFuture<Optional<D>, ReadFailedException> doRead(DOMDataReadTransaction readTx, LogicalDatastoreType store, InstanceIdentifier<D> path) {
        Preconditions.checkArgument((!path.isWildcarded() ? 1 : 0) != 0, (String)"Invalid read of wildcarded path %s", (Object[])new Object[]{path});
        return MappingCheckedFuture.create((ListenableFuture)Futures.transform((ListenableFuture)readTx.read(store, this.codec.toYangInstanceIdentifierBlocking(path)), this.codec.deserializeFunction(path)), (Function)ReadFailedException.MAPPER);
    }
}

