/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.Map;
import org.opendaylight.controller.md.sal.binding.impl.AbstractForwardedTransaction;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public abstract class AbstractWriteTransaction<T extends DOMDataWriteTransaction>
extends AbstractForwardedTransaction<T> {
    protected AbstractWriteTransaction(T delegate, BindingToNormalizedNodeCodec codec) {
        super(delegate, codec);
    }

    public final <U extends DataObject> void put(LogicalDatastoreType store, InstanceIdentifier<U> path, U data, boolean createParents) {
        Preconditions.checkArgument((!path.isWildcarded() ? 1 : 0) != 0, (String)"Cannot put data into wildcarded path %s", (Object[])new Object[]{path});
        Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> normalized = this.getCodec().toNormalizedNode(path, data);
        if (createParents) {
            this.ensureParentsByMerge(store, normalized.getKey(), path);
        } else {
            this.ensureListParentIfNeeded(store, path, normalized);
        }
        ((DOMDataWriteTransaction)this.getDelegate()).put(store, normalized.getKey(), normalized.getValue());
    }

    public final <U extends DataObject> void merge(LogicalDatastoreType store, InstanceIdentifier<U> path, U data, boolean createParents) {
        Preconditions.checkArgument((!path.isWildcarded() ? 1 : 0) != 0, (String)"Cannot merge data into wildcarded path %s", (Object[])new Object[]{path});
        Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> normalized = this.getCodec().toNormalizedNode(path, data);
        if (createParents) {
            this.ensureParentsByMerge(store, normalized.getKey(), path);
        } else {
            this.ensureListParentIfNeeded(store, path, normalized);
        }
        ((DOMDataWriteTransaction)this.getDelegate()).merge(store, normalized.getKey(), normalized.getValue());
    }

    private void ensureListParentIfNeeded(LogicalDatastoreType store, InstanceIdentifier<?> path, Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> normalized) {
        if (Identifiable.class.isAssignableFrom(path.getTargetType())) {
            YangInstanceIdentifier parentMapPath = normalized.getKey().getParent();
            Preconditions.checkArgument((parentMapPath != null ? 1 : 0) != 0, (String)"Map path %s does not have a parent", (Object[])new Object[]{path});
            NormalizedNode<?, ?> emptyParent = this.getCodec().getDefaultNodeFor(parentMapPath);
            ((DOMDataWriteTransaction)this.getDelegate()).merge(store, parentMapPath, emptyParent);
        }
    }

    @Deprecated
    protected static Optional<YangInstanceIdentifier> getParent(YangInstanceIdentifier child) {
        return Optional.fromNullable((Object)child.getParent());
    }

    protected abstract void ensureParentsByMerge(LogicalDatastoreType var1, YangInstanceIdentifier var2, InstanceIdentifier<?> var3);

    protected final void doDelete(LogicalDatastoreType store, InstanceIdentifier<?> path) {
        Preconditions.checkArgument((!path.isWildcarded() ? 1 : 0) != 0, (String)"Cannot delete wildcarded path %s", (Object[])new Object[]{path});
        YangInstanceIdentifier normalized = this.getCodec().toYangInstanceIdentifierBlocking(path);
        ((DOMDataWriteTransaction)this.getDelegate()).delete(store, normalized);
    }

    protected final CheckedFuture<Void, TransactionCommitFailedException> doSubmit() {
        return ((DOMDataWriteTransaction)this.getDelegate()).submit();
    }

    protected final boolean doCancel() {
        return ((DOMDataWriteTransaction)this.getDelegate()).cancel();
    }
}

