/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMRpcImplementationAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingRpcAdapterRegistration;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcIdentifier;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementation;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementationRegistration;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public class BindingDOMRpcProviderServiceAdapter {
    private static final Set<YangInstanceIdentifier> GLOBAL = ImmutableSet.of((Object)YangInstanceIdentifier.EMPTY);
    private final BindingToNormalizedNodeCodec codec;
    private final DOMRpcProviderService domRpcRegistry;

    public BindingDOMRpcProviderServiceAdapter(DOMRpcProviderService domRpcRegistry, BindingToNormalizedNodeCodec codec) {
        this.codec = codec;
        this.domRpcRegistry = domRpcRegistry;
    }

    public <S extends RpcService, T extends S> ObjectRegistration<T> registerRpcImplementation(Class<S> type, T implementation) {
        return this.register(type, implementation, GLOBAL);
    }

    public <S extends RpcService, T extends S> ObjectRegistration<T> registerRpcImplementation(Class<S> type, T implementation, Set<InstanceIdentifier<?>> paths) {
        return this.register(type, implementation, this.toYangInstanceIdentifiers(paths));
    }

    private <S extends RpcService, T extends S> ObjectRegistration<T> register(Class<S> type, T implementation, Collection<YangInstanceIdentifier> rpcContextPaths) {
        ImmutableBiMap rpcs = this.codec.getRpcMethodToSchemaPath(type).inverse();
        BindingDOMRpcImplementationAdapter adapter = new BindingDOMRpcImplementationAdapter((BindingNormalizedNodeSerializer)this.codec.getCodecRegistry(), type, (Map<SchemaPath, Method>)rpcs, implementation);
        Set<DOMRpcIdentifier> domRpcs = BindingDOMRpcProviderServiceAdapter.createDomRpcIdentifiers(rpcs.keySet(), rpcContextPaths);
        DOMRpcImplementationRegistration domReg = this.domRpcRegistry.registerRpcImplementation((DOMRpcImplementation)adapter, domRpcs);
        return new BindingRpcAdapterRegistration<T>(implementation, domReg);
    }

    private static Set<DOMRpcIdentifier> createDomRpcIdentifiers(Set<SchemaPath> rpcs, Collection<YangInstanceIdentifier> paths) {
        HashSet<DOMRpcIdentifier> ret = new HashSet<DOMRpcIdentifier>();
        for (YangInstanceIdentifier path : paths) {
            for (SchemaPath rpc : rpcs) {
                ret.add(DOMRpcIdentifier.create((SchemaPath)rpc, (YangInstanceIdentifier)path));
            }
        }
        return ret;
    }

    private Collection<YangInstanceIdentifier> toYangInstanceIdentifiers(Set<InstanceIdentifier<?>> identifiers) {
        ArrayList<YangInstanceIdentifier> ret = new ArrayList<YangInstanceIdentifier>(identifiers.size());
        for (InstanceIdentifier<?> binding : identifiers) {
            ret.add(this.codec.toYangInstanceIdentifierCached(binding));
        }
        return ret;
    }
}

