/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.compat;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import java.util.concurrent.ExecutorService;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.MountPoint;
import org.opendaylight.controller.md.sal.binding.api.NotificationService;
import org.opendaylight.controller.md.sal.binding.compat.HeliumNotificationServiceAdapter;
import org.opendaylight.controller.md.sal.binding.compat.HydrogenDataBrokerAdapter;
import org.opendaylight.controller.md.sal.common.api.routing.RouteChangeListener;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareService;
import org.opendaylight.controller.sal.binding.api.NotificationListener;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.binding.api.RpcConsumerRegistry;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.controller.sal.binding.api.data.DataBrokerService;
import org.opendaylight.controller.sal.binding.api.data.DataChangeListener;
import org.opendaylight.controller.sal.binding.api.data.DataModificationTransaction;
import org.opendaylight.controller.sal.binding.api.mount.MountProviderInstance;
import org.opendaylight.controller.sal.binding.api.rpc.RpcContextIdentifier;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.RpcService;

@Deprecated
public class HydrogenMountInstanceAdapter
implements MountProviderInstance {
    private final ClassToInstanceMap<BindingAwareService> services;
    private final InstanceIdentifier<?> identifier;

    public HydrogenMountInstanceAdapter(MountPoint key) {
        Optional rpcRegistry;
        Optional notificationService;
        this.identifier = (InstanceIdentifier)key.getIdentifier();
        ImmutableClassToInstanceMap.Builder builder = ImmutableClassToInstanceMap.builder();
        Optional dataBroker = key.getService(DataBroker.class);
        if (dataBroker.isPresent()) {
            builder.put(DataBrokerService.class, (Object)new HydrogenDataBrokerAdapter((DataBroker)dataBroker.get()));
        }
        if ((notificationService = key.getService(NotificationService.class)).isPresent()) {
            builder.put(org.opendaylight.controller.sal.binding.api.NotificationService.class, (Object)new HeliumNotificationServiceAdapter((NotificationService)notificationService.get()));
        }
        if ((rpcRegistry = key.getService(RpcConsumerRegistry.class)).isPresent()) {
            builder.put(RpcConsumerRegistry.class, rpcRegistry.get());
        }
        this.services = builder.build();
    }

    private <T extends BindingAwareService> T service(Class<T> service) {
        BindingAwareService potential = (BindingAwareService)this.services.getInstance(service);
        Preconditions.checkState((potential != null ? 1 : 0) != 0, (String)"Service %s is not supported by mount point %s", (Object[])new Object[]{service, this.getIdentifier()});
        return (T)potential;
    }

    public <T extends RpcService> T getRpcService(Class<T> serviceInterface) {
        return (T)this.service(RpcConsumerRegistry.class).getRpcService(serviceInterface);
    }

    public InstanceIdentifier<?> getIdentifier() {
        return this.identifier;
    }

    public <T extends Notification> ListenerRegistration<NotificationListener<T>> registerNotificationListener(Class<T> notificationType, NotificationListener<T> listener) {
        return this.service(org.opendaylight.controller.sal.binding.api.NotificationService.class).registerNotificationListener(notificationType, listener);
    }

    public ListenerRegistration<org.opendaylight.yangtools.yang.binding.NotificationListener> registerNotificationListener(org.opendaylight.yangtools.yang.binding.NotificationListener listener) {
        return this.service(org.opendaylight.controller.sal.binding.api.NotificationService.class).registerNotificationListener(listener);
    }

    public DataModificationTransaction beginTransaction() {
        return this.service(DataBrokerService.class).beginTransaction();
    }

    public DataObject readConfigurationData(InstanceIdentifier<? extends DataObject> path) {
        return this.service(DataBrokerService.class).readConfigurationData(path);
    }

    public DataObject readOperationalData(InstanceIdentifier<? extends DataObject> path) {
        return this.service(DataBrokerService.class).readOperationalData(path);
    }

    public ListenerRegistration<DataChangeListener> registerDataChangeListener(InstanceIdentifier<? extends DataObject> path, DataChangeListener listener) {
        return this.service(DataBrokerService.class).registerDataChangeListener(path, listener);
    }

    public <T extends RpcService> BindingAwareBroker.RoutedRpcRegistration<T> addRoutedRpcImplementation(Class<T> serviceInterface, T implementation) throws IllegalStateException {
        return this.service(RpcProviderRegistry.class).addRoutedRpcImplementation(serviceInterface, implementation);
    }

    public <T extends RpcService> BindingAwareBroker.RpcRegistration<T> addRpcImplementation(Class<T> serviceInterface, T implementation) throws IllegalStateException {
        return this.service(RpcProviderRegistry.class).addRpcImplementation(serviceInterface, implementation);
    }

    public void publish(Notification notification) {
        this.service(NotificationProviderService.class).publish(notification);
    }

    public void publish(Notification notification, ExecutorService executor) {
        this.service(NotificationProviderService.class).publish(notification);
    }

    public ListenerRegistration<NotificationProviderService.NotificationInterestListener> registerInterestListener(NotificationProviderService.NotificationInterestListener interestListener) {
        return this.service(NotificationProviderService.class).registerInterestListener(interestListener);
    }

    public <L extends RouteChangeListener<RpcContextIdentifier, InstanceIdentifier<?>>> ListenerRegistration<L> registerRouteChangeListener(L arg0) {
        return this.service(RpcProviderRegistry.class).registerRouteChangeListener(arg0);
    }
}

