/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.compat;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.EventListener;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.controller.md.sal.binding.compat.AbstractNotificationListenerRegistration;
import org.opendaylight.controller.md.sal.binding.compat.AggregatedNotificationListenerRegistration;
import org.opendaylight.controller.md.sal.binding.compat.ListenerMapGeneration;
import org.opendaylight.controller.md.sal.binding.compat.NotificationInvoker;
import org.opendaylight.controller.md.sal.binding.compat.NotificationListenerRegistration;
import org.opendaylight.controller.md.sal.binding.compat.NotifyTask;
import org.opendaylight.controller.sal.binding.api.NotificationListener;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class HydrogenNotificationBrokerImpl
implements NotificationProviderService,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(HydrogenNotificationBrokerImpl.class);
    private final ListenerRegistry<NotificationProviderService.NotificationInterestListener> interestListeners = ListenerRegistry.create();
    private final AtomicReference<ListenerMapGeneration> listeners = new AtomicReference<ListenerMapGeneration>(new ListenerMapGeneration());
    private final ExecutorService executor;

    public HydrogenNotificationBrokerImpl(ExecutorService executor) {
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor);
    }

    public void publish(Notification notification) {
        this.publish(notification, this.executor);
    }

    public void publish(Notification notification, ExecutorService service) {
        for (NotificationListenerRegistration<?> r : this.listeners.get().listenersFor(notification)) {
            service.submit(new NotifyTask(r, notification));
        }
    }

    @GuardedBy(value="this")
    private Multimap<Class<? extends Notification>, NotificationListenerRegistration<?>> mutableListeners() {
        return HashMultimap.create(this.listeners.get().getListeners());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRegistrations(NotificationListenerRegistration<?> ... registrations) {
        NotificationListenerRegistration<?>[] notificationListenerRegistrationArray = this;
        synchronized (this) {
            Multimap<Class<? extends Notification>, NotificationListenerRegistration<?>> newListeners = this.mutableListeners();
            for (NotificationListenerRegistration<?> reg : registrations) {
                newListeners.put(reg.getType(), reg);
            }
            this.listeners.set(new ListenerMapGeneration(newListeners));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (NotificationListenerRegistration<?> reg : registrations) {
                super.announceNotificationSubscription(reg.getType());
            }
            return;
        }
    }

    private synchronized void removeRegistrations(NotificationListenerRegistration<?> ... registrations) {
        Multimap<Class<? extends Notification>, NotificationListenerRegistration<?>> newListeners = this.mutableListeners();
        for (NotificationListenerRegistration<?> reg : registrations) {
            newListeners.remove(reg.getType(), reg);
        }
        this.listeners.set(new ListenerMapGeneration(newListeners));
    }

    private void announceNotificationSubscription(Class<? extends Notification> notification) {
        for (ListenerRegistration listener : this.interestListeners) {
            try {
                ((NotificationProviderService.NotificationInterestListener)listener.getInstance()).onNotificationSubscribtion(notification);
            }
            catch (Exception e) {
                LOG.warn("Listener {} reported unexpected error on notification {}", new Object[]{listener.getInstance(), notification, e});
            }
        }
    }

    public ListenerRegistration<NotificationProviderService.NotificationInterestListener> registerInterestListener(NotificationProviderService.NotificationInterestListener interestListener) {
        ListenerRegistration registration = this.interestListeners.register((EventListener)interestListener);
        for (Class<? extends Notification> notification : this.listeners.get().getKnownTypes()) {
            interestListener.onNotificationSubscribtion(notification);
        }
        return registration;
    }

    public <T extends Notification> NotificationListenerRegistration<T> registerNotificationListener(Class<T> notificationType, NotificationListener<T> listener) {
        AbstractNotificationListenerRegistration reg = new AbstractNotificationListenerRegistration<T>(notificationType, listener){

            protected void removeRegistration() {
                HydrogenNotificationBrokerImpl.this.removeRegistrations(new NotificationListenerRegistration[]{this});
            }
        };
        this.addRegistrations(reg);
        return reg;
    }

    public ListenerRegistration<org.opendaylight.yangtools.yang.binding.NotificationListener> registerNotificationListener(org.opendaylight.yangtools.yang.binding.NotificationListener listener) {
        NotificationInvoker invoker = NotificationInvoker.invokerFor(listener);
        Set<Class<? extends Notification>> types = invoker.getSupportedNotifications();
        final NotificationListenerRegistration[] regs = new NotificationListenerRegistration[types.size()];
        int i = 0;
        for (Class<? extends Notification> type : types) {
            regs[i] = new AggregatedNotificationListenerRegistration<Notification, Object>(type, (NotificationListener)invoker, (Object)regs){

                protected void removeRegistration() {
                }
            };
            ++i;
        }
        this.addRegistrations(regs);
        return new AbstractListenerRegistration<org.opendaylight.yangtools.yang.binding.NotificationListener>(listener){

            protected void removeRegistration() {
                HydrogenNotificationBrokerImpl.this.removeRegistrations(regs);
                for (NotificationListenerRegistration reg : regs) {
                    reg.close();
                }
            }
        };
    }

    @Override
    public void close() {
    }
}

