/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.compat;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.sal.binding.api.NotificationListener;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.util.BindingReflections;
import org.opendaylight.yangtools.yang.binding.util.NotificationListenerInvoker;
import org.opendaylight.yangtools.yang.common.QName;

final class NotificationInvoker
implements NotificationListener<Notification> {
    private final org.opendaylight.yangtools.yang.binding.NotificationListener delegate;
    private final Map<Class<? extends Notification>, InvokerContext> invokers;

    private NotificationInvoker(org.opendaylight.yangtools.yang.binding.NotificationListener listener) {
        this.delegate = listener;
        HashMap<Class<? extends Notification>, InvokerContext> builder = new HashMap<Class<? extends Notification>, InvokerContext>();
        for (TypeToken ifaceToken : TypeToken.of(listener.getClass()).getTypes().interfaces()) {
            Class iface = ifaceToken.getRawType();
            if (!org.opendaylight.yangtools.yang.binding.NotificationListener.class.isAssignableFrom(iface) || !BindingReflections.isBindingClass((Class)iface)) continue;
            Class listenerType = iface;
            NotificationListenerInvoker invoker = NotificationListenerInvoker.from((Class)listenerType);
            for (Class<? extends Notification> type : NotificationInvoker.getNotificationTypes(listenerType)) {
                builder.put(type, new InvokerContext(BindingReflections.findQName(type), invoker));
            }
        }
        this.invokers = ImmutableMap.copyOf(builder);
    }

    public static NotificationInvoker invokerFor(org.opendaylight.yangtools.yang.binding.NotificationListener listener) {
        return new NotificationInvoker(listener);
    }

    public Set<Class<? extends Notification>> getSupportedNotifications() {
        return this.invokers.keySet();
    }

    public void onNotification(Notification notification) {
        this.getContext(notification.getImplementedInterface()).invoke(notification);
    }

    private InvokerContext getContext(Class<?> type) {
        return this.invokers.get(type);
    }

    private static Set<Class<? extends Notification>> getNotificationTypes(Class<? extends org.opendaylight.yangtools.yang.binding.NotificationListener> type) {
        HashSet<Class<? extends Notification>> ret = new HashSet<Class<? extends Notification>>();
        for (Method method : type.getMethods()) {
            if (!BindingReflections.isNotificationCallback((Method)method)) continue;
            Class<?> notification = method.getParameterTypes()[0];
            ret.add(notification);
        }
        return ret;
    }

    private final class InvokerContext {
        private final QName name;
        private final NotificationListenerInvoker invoker;

        private InvokerContext(QName name, NotificationListenerInvoker invoker) {
            this.name = name;
            this.invoker = invoker;
        }

        public void invoke(Notification notification) {
            this.invoker.invokeNotification(NotificationInvoker.this.delegate, this.name, (DataContainer)notification);
        }
    }
}

